# (c) cavaliba.com

# django command / cavaliba.py

import sys

from django.core.management.base import BaseCommand, CommandError

from app_user.aaa import start_command

from app_home.home import cavaliba_init
from app_home.home import cavaliba_update

from app_home.log import log_get_count
from app_home.log import log_list
from app_home.log import purge
from app_home.log import purge_all

from app_home.configuration import conf_list



class Command(BaseCommand):

    help = 'manage cavaliba configuration'

    # https://docs.python.org/3/library/argparse.html#name-or-flags
    def add_arguments(self, parser):
        parser.add_argument('action', type=str,  help="init, update, log, conf" )
        
        # parser.add_argument('--schema', type=str, help="use --list to see available values")
        # parser.add_argument('--format', type=str, default="yaml", help="yaml(default), json")
        # parser.add_argument('--key', type=str, help="export specific keyname")
        #parser.add_argument('--verbose', action='store_true', help='Verbose mode' )

        parser.add_argument('--log_purge_all', action='store_true', help='log: purge ALL log entries' )
        parser.add_argument('--log_purge', action='store_true', help='log: purge OLDER log entries' )
        parser.add_argument('--log_list', action='store_true', help="log: list recent logs")
        parser.add_argument('--log_start', type=int, default=0, help="log list start position")
        parser.add_argument('--log_end', type=int, default=10, help="log list end position")

        # conf
        #parser.add_argument('--conf_list', action='store_true', help="conf: list conf entries")



    def handle(self, *args, **options):

        action = options.get("action", None)

        if action:
            if action not in ["init", "update", "log", "conf"]:
                self.stderr.write("unknown action: " + action)
                sys.exit(1)

        start_command(command="cavaliba", action=action)

        # INIT
        if action == "init":
            cavaliba_init()
            self.stdout.write("init done.\n")

        # UPDATE
        if action == "update":
            cavaliba_update()
            self.stdout.write("update done.\n")

        
        # LOG
        if action == "log":

            want_list = options.get("log_list",False)
            want_purge = options.get("log_purge",False)
            want_purge_all = options.get("log_purge_all",False)
          
            log_start = options.get("log_start",0)
            log_end = options.get("log_end",10)

            count = 0

            count = log_get_count()
            self.stdout.write(f"log entries: {count}\n")


            if want_list:
                r = log_list(log_start,log_end)
                for i in r:
                    print(i)

            elif want_purge:
                count = purge()
                self.stdout.write(f"log deleted (old) : {count} entries")

            elif want_purge_all:
                count = purge_all()
                self.stdout.write(f"log deleted (all) : {count} entries")

            else:
                pass
                
        
            self.stdout.write("log done\n")


        if action == "conf":

            conf_objects = conf_list()
            for i  in conf_objects:
                print(f"{i.appname:10} {i.keyname:40} {i.value}" )

            self.stdout.write("conf done\n")

        # NEXT: stat update :  update_bigset()

