# (c) cavaliba.com - data - pipeline.py


from datetime import datetime
import re
import yaml
import uuid

from app_data.data import Instance 
from app_data.data import get_instances

# ---------------------------------------------------------------------
# Pipelines
# ---------------------------------------------------------------------

def list_pipelines(is_enabled=None):

    pipelines = get_instances(classname = "_pipeline", is_enabled=is_enabled)
    return pipelines


def get_pipeline(pipeline):

    pipeline_data = None

    instance = Instance(classname="_pipeline", iname=pipeline)
    if not instance:
        return

    content = {}
    try:
        content = instance.fields["content"].value[0]
    except Exception as e:
        print(f"ERR - can't access pipeline : {e}")
        return
    
    if content:
        try:
            pipeline_data = yaml.safe_load(content)
        except Exception as e:
            print(f"ERR - invalid pipeline content ({pipeline}): {e}")
            return

    return pipeline_data




def apply_pipeline(pipeline=None, datalist=None):
    '''
    data is a list of dict [ {}, {} , ]
    '''

    if not pipeline:
        return datalist

    if not datalist:
        return

    if not type(datalist) is list:
        return

    pipeline_data = get_pipeline(pipeline)

    if not pipeline_data:       
        print(f"No pipeline data for {pipeline}")
        return datalist

    # tasks ?
    if "tasks" not in pipeline_data:
        return datalist

    #for dataname, datadict in data.items():
    for datadict in datalist:
    
        # classname:keyname: => datadict{}
        for task in pipeline_data["tasks"]:
            
    
            if not type(task) is dict:
                continue

            for t,v in task.items():


                if t == "field_keep":
                    purge=[]
                    try:
                        for f in datadict:
                            if f in ["classname", "keyname"]:
                                continue
                            if f not in v:
                                purge.append(f)
                        for f in purge:
                            datadict.pop(f)
                    except Exception as e:
                        pass


                elif t == "field_add":
                    datadict[v] = ""

                elif t == "field_copy":
                    try:
                        (v1,v2) = v
                    except:
                        continue
                    try:
                        datadict[v2] = datadict[v1]
                    except:
                        datadict[v2] = ""

                elif t == "field_rename":
                    try:
                        (v1,v2) = v
                    except:
                        continue
                    try:
                        datadict[v2] = datadict[v1]
                        datadict.pop(v1)
                    except:
                        datadict[v2] = ""

                elif t == "field_delete":
                    try:
                        datadict.pop(v, None)
                    except:
                        pass

                elif t == "field_lower":
                    try:
                        datadict[v] = datadict[v].lower()
                    except:
                        pass

                elif t == "field_upper":
                    try:
                        datadict[v] = datadict[v].upper()
                    except:
                        pass

                elif t == "field_date_now":
                    datadict[v] = str ( datetime.today().strftime('%Y-%m-%d') )

                elif t == "field_time_now":
                    datadict[v] = str ( datetime.today().strftime('%H:%M:%S') )
                
                elif t == "field_datetime_now":
                    datadict[v] = str ( datetime.today().strftime('%Y-%m-%d %H:%M:%S') )

                # field_regexp_sub: ["field","Hello","Hi"]
                elif t == "field_regexp_sub":
                    try:
                        (field,pattern,replace) = v
                    except:
                        continue
                    try:
                        datadict[field] = re.sub(pattern, replace, datadict[field])
                    except:
                        pass

                elif t == "field_uuid":
                    try:
                        datadict[v] = str(uuid.uuid4())
                    except:
                        pass

                else:
                    # unknown task
                    pass


    return datalist

