# (c) cavaliba.com


from io import StringIO
#import io

from django.core.management import call_command
from django.test import TestCase
from django.test import TransactionTestCase

from app_home.home import cavaliba_update


class CommandTest(TestCase):

    # def setUp(self):
    #     pass

    @classmethod
    def setUpTestData(cls):
        cavaliba_update(verbose=False)


    def test_check_command(self):

        output = StringIO()
        err = StringIO()
        call_command("check", verbosity=2, stdout=output)
        assert("System check identified no issues" in output.getvalue())    


    def test_update_command(self):

        output = StringIO()
        err = StringIO()
        call_command("cavaliba","update", verbosity=2, stdout=output)
        assert("update done" in output.getvalue())    


    def test_conf_command(self):

        output = StringIO()
        err = StringIO()
        call_command("cavaliba", "conf", verbosity=2, stdout=output)
        assert("conf done" in output.getvalue())    


    def test_log_purge_command(self):

        output = StringIO()
        err = StringIO()
        call_command("cavaliba","log" ,"--log_purge", verbosity=2, stdout=output)
        assert("log done" in output.getvalue())    


    def test_load_command_unknown(self):

        output = StringIO()
        err = StringIO()
        call_command("cavaliba_load", "unknown_file", verbosity=2, stdout=output, stderr=err)
        assert("load done" in output.getvalue())
        assert("SKIP - Unknown filename" in err.getvalue())
