# tests app_sirene

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse


from app_home.home import cavaliba_update
from app_home.configuration import get_configuration
from app_home.models import CavalibaConfiguration



class AppSireneAnonymousTest(TestCase):

    @classmethod
    def setUpTestData(cls):
        cavaliba_update(verbose=False)


    def test_init(self):
        self.assertEqual(True, True)


    def test_public(self):
        response = self.client.get(reverse('app_sirene:index'))
        self.assertEqual(response.status_code, 200)


    def test_anonymous(self):
        response = self.client.get(reverse('app_sirene:anonymous'))
        # user = admin
        self.assertEqual(response.status_code, 302)


    def test_trusted_ip(self):
        conf = CavalibaConfiguration.objects.get(appname="user",keyname="TRUSTED_ANONYMOUS_IPS")
        conf.value="0.0.0.0/0"
        conf.save()

        response = self.client.get(reverse('app_sirene:anonymous'))
        self.assertEqual(response.status_code, 200)

        response = self.client.get(reverse('app_sirene:private'))
        self.assertEqual(response.status_code, 302)

