# (c) cavaliba.com - data - exporter.py

import yaml
import json

from django.http import HttpResponse
from django.forms.models import model_to_dict



from .data import get_classes
from .data import get_class_by_name
from .data import get_schema

from .data import get_instances
from .data import get_instance_by_name
from .data import Instance

# export JSON / YAML / CSV instances


# --------------------------------------------------------
#  CLI exporter 
# --------------------------------------------------------

def cli_class_listdict_format(classes=None):

    datalist = []

    dict_attributs =  [
        "keyname", "displayname", "is_enabled", 
        "is_bigset", "count_estimation","handle_method",
        "icon","page","order",
        "p_read","p_create","p_update","p_delete","p_export","p_import","p_admin",
        ] 

    if not classes:
        classes = get_classes()

    for classname in classes:

        classobj = get_class_by_name(classname)
        schema = get_schema(classname=classname)

        m = model_to_dict(classobj, fields=dict_attributs)
        m["classname"] = "_schema"

        for fieldname,fieldstruct in schema.items():
            m[fieldname] = fieldstruct

        datalist.append(m)
        
    return datalist


def cli_listdict_format(classes=None, keyname=None):

    datalist = []

    if not classes:
        classes = get_classes()

    for classname in classes:
        
        schema = get_schema(classname=classname)

        # Queryset of DB objects
        qs_iobj = []
        if keyname:
            a = get_instance_by_name(classname=classname, iname=keyname)
            if a:
                qs_iobj = [a]
        else:   
            qs_iobj =  get_instances(classname = classname)
        

        for iobj in qs_iobj:
            instance = Instance(classname=classname, iobj=iobj,  schema=schema)
            data = instance.get_dict_for_export()            
            datalist.append(data)

    return datalist

# --------------------------------------------------------
#  UI exporter
# --------------------------------------------------------

def data_listdict_format(classes=None, keyname=None):

    datalist = []

    if not classes:
        classes = get_classes()

    for classname in classes:
        
        schema = get_schema(classname=classname)

        # Queryset of DB objects
        qs_iobj = []
        if keyname:
            a = get_instance_by_name(classname=classname, iname=keyname)
            if a:
                qs_iobj = [a]
        else:   
            qs_iobj =  get_instances(classname = classname)
        

        for iobj in qs_iobj:
            instance = Instance(classname=classname, iobj=iobj,  schema=schema)
            data = instance.get_dict_for_export()            
            datalist.append(data)

    return datalist


#YAML
class MyYamlDumper(yaml.SafeDumper):
    def write_line_break(self, data=None):
        super().write_line_break(data)
        if len(self.indents) < 2:
            super().write_line_break()

def data_yaml_response(classes=None):
    datalist = data_listdict_format(classes=classes)
    filedata = yaml.dump(datalist, allow_unicode=True, Dumper=MyYamlDumper, sort_keys=False)
    response = HttpResponse(filedata, content_type='text/yaml')  
    response['Content-Disposition'] = 'attachment; filename="data.yaml"'
    return response

# JSON
def data_json_response(classes=None):
    datalist = data_listdict_format(classes=classes)
    filedata = json.dumps(datalist, indent=4, ensure_ascii=False)
    response = HttpResponse(filedata, content_type='text/json')  
    response['Content-Disposition'] = 'attachment; filename="data.json"'
    return response
