
from .field import Field

# -------------
# FLOAT
# -------------
class FieldFloat(Field):


    def get_datapoint_ui_detail(self):
        datapoint = super().get_datapoint_ui_detail()
        a = [str(i) for i in self.value]
        datapoint["value"] = ' '.join(a)
        return datapoint

    def get_datapoint_ui_edit(self):
        datapoint = super().get_datapoint_ui_edit()
        # force to string and separate multi value with space
        a = [str(i) for i in self.value]
        datapoint["value"] = ' '.join(a)
        return datapoint

    def merge_edit_data(self, data):
        ''' data is a list of string ["3.2 5.4", ...]'''
        self.value = []
        try:
            values = data[0].split()
        except:
            return
        for i in values:
            try:
                self.value.append(float(i))
            except:
                pass

    def merge_new_data(self, data):
        ''' data is a list of string ["3.2 5.4", ...] ; first item is useful only'''
        self.value = []
        try:
            values = data[0].split()
        except:
            return
        for i in values:
            try:
                self.value.append(float(i))
            except:
                pass


    def is_valid(self):
        r = super().is_valid()
        for v in self.value:
            if type(v) is str:
                if len(v) == 0:
                    continue            
            try:
                float(v)
            except:
                return False
            
            options =  self.fieldschema.get("dataformat_ext", "")
            if options:
                dictopt = options.split()

                for opt in dictopt:

                    # greater or equal
                    if opt.startswith("gte_"):
                        (tmp, valopt) = opt.split('_')
                        for v in self.value:
                            try:
                                if v < float(valopt):
                                    return False
                            except:
                                pass

                    # greater strict
                    if opt.startswith("gte_"):
                        (tmp, valopt) = opt.split('_')
                        for v in self.value:
                            try:
                                if v <= float(valopt):
                                    return False
                            except:
                                pass
                    
                    # lesser or equal
                    if opt.startswith("lte_"):
                        (tmp, valopt) = opt.split('_')
                        for v in self.value:
                            try:
                                if v > float(valopt):
                                    return False
                            except:
                                pass

                    # lesser strict
                    if opt.startswith("lt_"):
                        (tmp, valopt) = opt.split('_')
                        for v in self.value:
                            try:
                                if v >= float(valopt):
                                    return False
                            except:
                                pass


        return r
