# (c) cavaliba.com - field_test.py

import yaml
import json
from .field import Field


# -------------
# TEXT
# -------------
class FieldText(Field):



    def get_datapoint_ui_detail(self):

        datapoint = super().get_datapoint_ui_detail()

        v = ""
        if self.value:
            if len(self.value) == 1:
                v = self.value[0]
            elif len(self.value) > 1:
                try:
                    v = ', '.join(str(self.value))
                except:
                    v = ""

        if self.fieldschema["dataformat_ext"] == "yaml":
            try:
                data = yaml.safe_load(v)
                datapoint["value"] = yaml.dump(data, allow_unicode=True, sort_keys=False)
            except:
                datapoint["value"] = v

        elif self.fieldschema["dataformat_ext"] == "json":
            try:
                data = yaml.safe_load(v)
                datapoint["value"] = json.dumps(data, indent=4)
            except:
                datapoint["value"] = v

        # NEXT: markdown

        else:
            datapoint["value"] = v



        return datapoint









    def merge_edit_data(self, data):
        self.value = []
        for i in data:
            if len(i) > 0:
                self.value.append(i)

    def merge_new_data(self, data):
        self.value = []
        for i in data:
            if len(i) > 0:
                self.value.append(i)

    def merge_import_data(self, data):
        # no split composite !
        self.value = [data]

    def is_valid(self):
        r = super().is_valid()
        # TODO
        return r

