import datetime

from .field import Field

# -------------
# TIME
# -------------
class FieldTime(Field):

    def merge_edit_data(self, data):
        self.value = []
        for i in data:
            if len(i) > 0:
                self.value.append(i)

    def merge_new_data(self, data):
        self.value = []
        for i in data:
            if len(i) > 0:
                self.value.append(i)
                
    def is_valid(self):
        r = super().is_valid()
        for v in self.value:
            if type(v) is str:
                if len(v) == 0:
                    continue                                    
            try:
                timeformat = "%H:%M:%S"
                validtime = datetime.datetime.strptime(v, timeformat)
            except:
                return False
        return r



