# (c) cavaliba.com - data - permissions.py


def is_user_in_group(aaa=None, gname=None):

    if gname in aaa["groups"] + aaa["groups_indirect"]:
        return True
    return False


# -- read

def has_read_permission_on_class(aaa=None, classobj=None):
    # classobj is a DB object

    if not aaa:
        return False
    
    if not classobj:
        return False

    if '*' in aaa['perms']:
        return True
    
    # global p_data_admin
    if "p_data_admin" in aaa["perms"]:
        return True

    # p_admin on classobj
    if classobj.p_admin:
        if classobj.p_admin in aaa["perms"]:
            return True

    # p_read on single class rules
    if classobj.p_read:
        if classobj.p_read in aaa["perms"]:
            return True
        else:
            return False
    
    # default to all-class permission
    if "p_data_read" in aaa["perms"]:
        return True

    return False


def has_read_permission_on_instance(aaa=None, iobj=None):
    # iobj is a DB object

    if not aaa:
        return False
    
    if not iobj:
        return False

    if '*' in aaa['perms']:
        return True

    if "p_data_admin" in aaa["perms"]:
        return True

    # p_admin on classobj ? (allow direct & stop inheritance)
    if iobj.classobj.p_admin:
        if iobj.classobj.p_admin in aaa["perms"]:
            return True

    # instance permission
    if iobj.p_read:
        if iobj.p_read in aaa["perms"]:
            return True
        else:
            return False
        
    # class permission
    if has_read_permission_on_class(aaa, classobj=iobj.classobj):
        return True

    # # default    
    # if "p_data_read" in aaa["perms"]:
    #     return True

    return False

# -- delete

def has_delete_permission_on_class(aaa=None, classobj=None):
    # classobj is a DB object

    if not aaa:
        return False
    
    if not classobj:
        return False

    if '*' in aaa['perms']:
        return True

    # global p_data_admin: allow all on data
    if "p_data_admin" in aaa["perms"]:
        return True

    # p_admin on classobj : allow all on this class
    if classobj.p_admin:
        if classobj.p_admin in aaa["perms"]:
            return True

    # if defined, single class permission rules
    if classobj.p_delete:
        if classobj.p_delete in aaa["perms"]:
            return True
        else:
            return False
    
    # default: check  all-class permission
    if "p_data_delete" in aaa["perms"]:
        return True

    return False


def has_delete_permission_on_instance(aaa=None, iobj=None):
    # iobj is a DB object

    if not aaa:
        return False
    
    if not iobj:
        return False

    if '*' in aaa['perms']:
        return True

    if "p_data_admin" in aaa["perms"]:
        return True
   
    # p_admin on classobj: allow all on this class; no override 
    if iobj.classobj.p_admin:
        if iobj.classobj.p_admin in aaa["perms"]:
            return True
            
    # if defined, instance permission rules
    if iobj.p_delete:
        if iobj.p_delete in aaa["perms"]:
            return True
        else:
            return False

    # default to class permission
    if has_delete_permission_on_class(aaa, classobj=iobj.classobj):
        return True
    
    return False



# -- edit / update

def has_edit_permission_on_class(aaa=None, classobj=None):
    # classobj is a DB object

    if not aaa:
        return False
    
    if not classobj:
        return False

    if '*' in aaa['perms']:
        return True

    # global p_data_admin: allow all on data / no override
    if "p_data_admin" in aaa["perms"]:
        return True

    # p_admin on classobj : allow all on this class / no override
    if classobj.p_admin:
        if classobj.p_admin in aaa["perms"]:
            return True

    #  single class permission rules if defined
    if classobj.p_update:
        if classobj.p_update in aaa["perms"]:
            return True
        else:
            return False
    
    # default: to all-class permission
    if "p_data_update" in aaa["perms"]:
        return True

    return False


def has_edit_permission_on_instance(aaa=None, iobj=None):
    # iobj is a DB object

    if not aaa:
        return False
    
    if not iobj:
        return False

    if '*' in aaa['perms']:
        return True

    if "p_data_admin" in aaa["perms"]:
        return True
   
    # p_admin on classobj: allow all on this class; no override 
    if iobj.classobj.p_admin:
        if iobj.classobj.p_admin in aaa["perms"]:
            return True
            
    # if defined, instance permission rules 
    if iobj.p_update:
        if iobj.p_update in aaa["perms"]:
            return True
        else:
            return False

    # default to class permission
    if has_edit_permission_on_class(aaa, classobj=iobj.classobj):
        return True

    return False


# -- create new instance

def has_create_permission_on_class(aaa=None, classobj=None):
    # classobj is a DB object

    if not aaa:
        return False
    
    if not classobj:
        return False

    if '*' in aaa['perms']:
        return True

    # global p_data_admin: allow all on DATA / no override
    if "p_data_admin" in aaa["perms"]:
        return True

    # classlevel p_admin if defined : allow all on this class / no override
    if classobj.p_admin:
        if classobj.p_admin in aaa["perms"]:
            return True

    # if defined for this class, rules 
    if classobj.p_create:
        if classobj.p_create in aaa["perms"]:
            return True
        else:
            return False
    
    # default: global create permission on all classes
    if "p_data_create" in aaa["perms"]:
        return True

    return False


# -- class export permission 

def has_export_permission_on_class(aaa=None, classobj=None):
    # classobj is a DB object

    if not aaa:
        return False
    
    if not classobj:
        return False

    if '*' in aaa['perms']:
        return True

    # global p_data_admin: allow all on all CLASS / no override
    if "p_data_admin" in aaa["perms"]:
        return True

    # classlevel p_admin if defined : allow all on this class / no override
    if classobj.p_admin:
        if classobj.p_admin in aaa["perms"]:
            return True

    # if defined for this class, rules
    if classobj.p_export:
        if classobj.p_export in aaa["perms"]:
            return True
        else:
            return False
    
    # default: global export permission for all classes
    if "p_data_export" in aaa["perms"]:
        return True

    return False


# -- class import permission 

def has_import_permission_on_class(aaa=None, classobj=None):
    # classobj is a DB object

    if not aaa:
        return False
    
    if not classobj:
        return False

    if '*' in aaa['perms']:
        return True

    # global p_data_admin: allow all on all CLASS / no override
    if "p_data_admin" in aaa["perms"]:
        return True

    # classlevel p_admin if defined : allow all on this class / no override
    if classobj.p_admin:
        if classobj.p_admin in aaa["perms"]:
            return True

    # if defined for this class, rules
    if classobj.p_import:
        if classobj.p_import in aaa["perms"]:
            return True
        else:
            return False
    
    # default: global all-class permission rules
    if "p_data_import" in aaa["perms"]:
        return True

    return False