# (c) cavaliba.com - data - search.py

import re
from django.db.models import Q

from .models import DataInstance
#from .data import Instance



def get_query_from_request(request=None):

    if not request:
        return None
    
    query = ""
    if request.method == "POST":
        if request.POST.get('query'):
            query = request.POST.get('query')
            m = re.compile(r'^[a-zA-Z0-9()_\/\.\s]*$')
            if not m.match(query):
                query = ""
    
    return query



def get_instance_from_query(query=None, classobj=None, offset=None, limit=None):

    if not classobj:
        return
    
    if not query:
        query = ""

    if not offset:
        offset = 0

    if limit:
        try:
            int(limit)
            if limit <= 0:
                return
        except:
            return



    if len(query) > 0:
        #instances = DataInstance.objects.filter(classobj=classobj, keyname__icontains=query)[offset:limit]
        qc = Q(classobj=classobj)
        q= Q()
        for item in query.split():
            q |= Q(keyname__icontains=item)
            q |= Q(displayname__icontains=item)
            q |= Q(data_json__icontains=item)
    
        if limit:
            instances = DataInstance.objects.filter(qc & q)[offset:limit]
        else:
            instances = DataInstance.objects.filter(qc & q)[offset:]


    else:
        if limit:
            instances = DataInstance.objects.filter(classobj=classobj)[offset:limit]
        else:
            instances = DataInstance.objects.filter(classobj=classobj)[offset:]


    return instances



