# (c) cavaliba.com
# unittest - test_data_load

import sys
import yaml

from django.test import TestCase
from django.test import override_settings


import app_home.cache as cache
from app_home.configuration import get_configuration
#from app_home.home import cavaliba_update

from app_data.models import DataSchema
from app_data.models import DataClass

from app_data.loader import load_broker




class DataLoadTest(TestCase):

    fixtures = ["test"]

    def setUp(self):
        cache.init()


    def test_schema_exist(self):
        classobj = DataClass.objects.get(keyname='test1')
        self.assertIsNotNone(classobj)


    def test_schema_delete(self):
        datalist = yaml.safe_load('''
            - classname: _schema
              keyname: test1
              _action: delete
            ''')
        aaa = {'perms':'*'}
        r = load_broker(datalist=datalist, aaa=aaa, verbose=False)

        classobj = DataClass.objects.filter(keyname='test1').first()
        self.assertIsNone(classobj)


    def test_schema_disable_enable(self):
        datalist = yaml.safe_load('''
            - classname: _schema
              keyname: test1
              _action: disable
            ''')
        aaa = {'perms':'*'}

        load_broker(datalist=datalist, aaa=aaa, verbose=False)
        classobj = DataClass.objects.filter(keyname='test1').first()
        self.assertEqual(classobj.is_enabled, False)

        datalist = yaml.safe_load('''
            - classname: _schema
              keyname: test1
              _action: enable
            ''')
        load_broker(datalist=datalist, aaa=aaa, verbose=False)
        classobj = DataClass.objects.filter(keyname='test1').first()
        self.assertEqual(classobj.is_enabled, True)










