# (c) cavaliba.com - test_user.py

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse

from app_home.home import cavaliba_update
from app_home.configuration import get_configuration


from app_user.models import SireneUser
from app_user.models import SireneGroup

from app_user.group import group_get_by_id
from app_user.group import group_get_by_name
from app_user.group import group_get_by_data
from app_user.group import group_delete

import app_home.cache as cache



class AnonymousTest(TestCase):

    fixtures = ["test"]

    def setUp(self):
        cache.init()

    def test_anonymous_public(self):
        response = self.client.get(reverse('app_home:index'))
        self.assertEqual(response.status_code, 302)



# class GroupTest(TransactionTestCase):

#     @classmethod
#     def setUpClass(cls):

#         super().setUpClass()

#         cavaliba_update(verbose=False)


class GroupTest(TestCase):
  
    fixtures = ["test"]

    def setUp(self):
        cache.init()


    def test_group_get_by_id(self):

        gobj = SireneGroup(keyname='group_unittest')
        gobj.save()

        gobj2 = group_get_by_id(gobj.id)
        self.assertEqual(gobj2.keyname, 'group_unittest')


    def test_group_get_by_data(self):

        gobj = SireneGroup(keyname='group_unittest')
        gobj.save()

        gobj2 = group_get_by_data({'keyname':'group_unittest'})
        self.assertEqual(gobj2.keyname, 'group_unittest')



    def test_group_get_by_name(self):

        gobj = SireneGroup(keyname='group_unittest')
        gobj.save()

        gobj2 = group_get_by_name("group_unittest")
        self.assertEqual(gobj2.keyname, 'group_unittest')


    def test_group_delete(self):

        gobj = SireneGroup(keyname='group_unittest')
        gobj.save()

        gobj = group_get_by_name("group_unittest")
        r = group_delete(gobj)
        self.assertEqual(r, True)

        # non-existent group
        gobj = group_get_by_name("group_unittest2")
        r = group_delete(gobj)
        self.assertEqual(r, False)

    def test_group_delete_builtin(self):
        
        gobj = SireneGroup(keyname='group_unittest_builtin')
        gobj.is_builtin = True
        gobj.save()
        
        r = group_delete(gobj)
        self.assertEqual(r, False)

