---
title: cavctl
description: cavctl remote CLI command
weight: 1010
---

The `cavctl` binary is a standalone command-line tool (CLI) to manage Cavaliba systems remotely. It is is a golang thin wrapper around the Cavaliba API, built with cobra/viper librairies.


## Setup overview

1. Select the appropriate binary from the cavaliba/cavctl/bin/ folder
2. Create an API Key in your Cavaliba instance with appropriate permissions (eg. role_api_read)
3. Optionnaly, create a ~/cavaliba/cavctl.yaml configuration file
4. run `cavctl` from your shell


## Help flag

```
$ cavctl -h

cavctl is a CLI standalone command to manage cavaliba systems

Usage:
  cavctl [command]

Available Commands:
  help        Help about any command
  version     displays remote cavaliba version
  (...)

```

## Empty command

Retrieves the cavctl version.

```bash
$ cavctl
cavctl version: 1.0.0
```


## Explicit command-line parameters

In order to query a cavaliba system, you need to define the API endpoint :

```
$ cavctl version --url http://127.0.0.1:8000/ --client_id key1 --client_secret goodsecret
{
    "version": "3.21.0"
}
```

You can check the status code with the `-v` option (verbose):

```
$ cavctl version --url http://127.0.0.1:8000/ --client_id key1 --client_secret wrongsecret -v
(...)
status:     401
(...)
```

A 401 status code is an unauthorized response.


## Use a config file

To save typing, use a config file.

```
$ cavctl --config myconfig.yaml

```

By default, `cavctl` will try `$HOME/.cavaliba/cavaliba.yaml` which you should populate with your regular parameters.


Example:

```yaml cavaliba.yaml
url: http://localhost:8000/
client_id: key1
client_secret: xxxxxxxxxxxxx
timeout: 1000
ssl_skipverify: false
```



## Verbose flag

Use `-v` option to display more informations, such as config file, API URL, duration, response code, etc.

```bash
$ cavctl version -v
Configuration: /home/cavaliba/.cavaliba/cavaliba.yaml
url: http://localhost:8000/
timeout: 1000
client_id: key1
----- API Call -----
API:        http://localhost:8000/home/api/version/
status:     200
duration:   56.20441ms
----- API Result -----
{
    "version": "3.21.0"
}
```

## ssl_skipverify

Version: 1.1.0


Ignore Cavaliba URL TLS/SSL Cerificate check (duration, issuer, fqdn).


Default: false

Usage:

```
# CLI
cavctl --ssl_skipverify

# envvar
export CAVALIBA_SSL_SKIPVERIFY=true && cavctl -v
ssl_skipverify: true


# persist in cavaliba.yaml:
ssl_skipverify: true
```

## version command

This command calls the configured cavaliba instance and retrieves it's version.

```bash
$ cavctl version
{
    "version": "3.21.0"
}
```



## info command

This command calls the configured cavaliba instance and retrive key system informations.



## Build

You can build your own cavctl binary. Setup GOLANG on your system and download the latest cavaliba dsitribution.

Use the `make build` from the cavaliba/cavctl/ source directory. The resulting binary is in the build/ subfolder. 

You can copy/install this binary on other machines with the same OS/ARCH. See GOLANG cross compilation for details.


# Revisions

2025/08/22 - v1.1.0 - error display, ssl_skip_verify
2025/08/20 - v1.0.0 - version command

