---
title: Basic Authentication 
description: Configure Basic Authentication 
weight: 810
---


Basic Authentication is an **external** authentication mode. It is not performed by the Cavaliba application itself. A front Web server is in charge of this authentication and will set standard HTTP Authentication headers, passed to Cavaliba.

This mode, like the Local Authentication mode, is suitable for small deployment, with no advanced authentication and access management features. User management is to be performed both externally and inside Cavaliba to map external users to Cavaliba users.


## Internal Cavaliba Web Server (NGINX)

Basic Authentication can be configured at the Cavaliba container with the NGINX Web server.

Steps:

* edit the nginx.conf file next to the docker-compose.yml, to uncomment basic authentication lines 
* create a standard htpassword file (htpasswd)
* edit the docker-compose.yml to uncomment the line mounting this htpassword file inside the nginx container
* in .env configure CAVALIBA_AUTH_MODE=basic
* restart docker containers
* populate / manage the htpasswd file on the server

You may then edit and update dynamically the htpasswd file, to add or remove users, change their password, etc.

## External Web-Server / Reverse-PRoxy 

Basic Authentication can also be configured at any upstream Web server / Reverse-Proxy which may be set up before reaching Cavaliba Application.

This Reverse-Proxy **must** set the HTTP Authentication Header to let Cavaliba obtain the user's login value.


## Cavaliba users

Don't forget to always map external users (in the htpasswd), to users objects in the Cavaliba User model with the same login value. Add group membership, roles, permissions, etc.

