# (c) cavaliba.com - data - field - externam

from .field import Field

# -------------
# EXTERNAL
# -------------
class FieldExternal(Field):

    # dataformat: external
    # dataformat_ext: parent_fieldname remote_fieldname  subfield1  subfield2 ...
    # subfield# : name of resolved source schema fields to inject in local Instance


    # /!\ external FieldType fieldname **must** start with an underscore
    # the resolved schema field will be create with the same name, without underscore
    # remote_fieldname must match remote schema (with _ if another ext., without _ if schema)


        
    def get_parent_fieldname(self):
        #return self.parent_fieldname  
        try:
            return self.dataformat_ext.split()[0]
        except:
            return []


    def get_remote_fieldname(self):
        try:
            return self.dataformat_ext.split()[1]
        except:
            return []


    def get_subfields(self):
        try:
            return self.dataformat_ext.split()[2:]
        except:
            return []


    def print(self):
        try:
            # value_str = '|'.join(self.value)
            print(f"  Field: {self.fieldname} = {self.value}")
        except:
            pass


    def is_valid(self):
        r = super().is_valid()

        if not self.fieldname.startswith("_"):
            return False
        
        return r

