# tests app_sirene

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django

from app_user.models import SireneUser, SireneGroup
from app_user.role import role_get_by_name

import app_home.cache as cache
from app_home.models import CavalibaConfiguration


class AppSireneAnonymousTest(TestCase):

    fixtures = ["test"]
    def setUp(self):
        cache.init()
        cache_django.clear()
        
        user = SireneUser.objects.create(login="unittest", firstname="unittestname")
        user.save()

        role = role_get_by_name("role_default")
        role.users.add(user)
        role.save()

    def tearDown(self):
        # super().tearDown()
        cache_django.clear()


    def test_public(self):
        response = self.client.get(reverse('app_sirene:index'))
        self.assertEqual(response.status_code, 200)

    def test_anonymous_ko(self):
        response = self.client.get(reverse('app_sirene:anonymous'))
        #print(response.content)
        self.assertEqual(response.status_code, 302)


    # def test_anonymous_ok_auth(self):
    #     response = self.client.get(reverse('app_sirene:anonymous'))
    #     self.assertEqual(response.status_code, 200)


    def test_trusted_ip(self):
        conf = CavalibaConfiguration.objects.get(appname="user",keyname="TRUSTED_ANONYMOUS_IPS")
        conf.value="0.0.0.0/0"
        conf.save()

        response = self.client.get(reverse('app_sirene:anonymous'))
        self.assertEqual(response.status_code, 200)

        response = self.client.get(reverse('app_sirene:private'))
        self.assertEqual(response.status_code, 302)

