---
title: Local Authentication 
description: Configure Local Authentication 
weight: 840
---

This is the default mode, which is enabled after a fresh install.

This mode is suitable for  small deployment with a limited number of users, and little to no need for advanced features such as multi-factor authentication, registration/sign-up forms, password loss/change self-service, etc.

User accounts (login/password) are configured manually and directly inside in Cavaliba by an administrator.

Sign-in/Sign-out Web forms are provided by Cavaliba.

## Steps to configure this mode

* remove/comment OAUTH configuration blocs in nginx.conf and docker-compose.yml
* in .env configure CAVALIBA_AUTH_MODE=local
* restart docker containers
* login with admin or other provisionned account in Cavaliba



## How does-it work

In Local Authentication mode, users are authenticated ny the Django App Framework. They must exist in the Django auth structure, which is basically a specific DB table. Login, Password are the sole mandatory attributes for the purpose of authenticating a user.

Then, the user must also in the Cavaliba Data Model, with the same login. This model is common to all authentication modes. It defines who is the user (extended attributes, group membership, directory pages), if and what he can do when logged-in,  what notifications he will receive, etc.


## Add a user

Manually from Cavaliba  :

* open the DB Admin tool from Cavaliba main menu
* select the django user table
* clic the "add user" top-right button and fill-in the form : login, password
* get back to cavaliba
* go to the Cavaliba User module
* add the user (same login) with extended informations, group membership, etc.


CLI / Shell:

     $ cd cavaliba/
     $ docker exec -it cavaliba_app python manage.py shell
	  >>> from django.contrib.auth.models import User
	  >>> user = User.objects.create_user("john", "lennon@thebeatles.com", "johnpassword")

## Suspend / Remove a user

* open the DB Admin tool from Cavaliba main menu
* select the django user table
* select the appropriate user
* edit the form, disable / remove and save

As this point, the user can't sign-in to cavaliba. But he still exists in the Data Model and can receive notifications (Sirene). 

* go to the Cavaliba User module
* select the user (same login) and disable/remove


## Change a user's password

Web interface :

* open the DB Admin tool from Cavaliba main menu
* select the django user table
* select the appropriate user
* use the change password tool

CLI / Shell

     $ cd cavaliba/
     $ docker exec -it cavaliba_app python manage.py changepassword LOGIN


