# (c) cavaliba.com - data - field - schema 

import copy
import pprint

from .field import Field

from app_data.models import DataClass
from app_data.models import DataInstance

from app_home.configuration import get_configuration

import app_home.cache as cache


def local_get_class_by_name(keyname):

    # no-cache
    #dataclass = DataClass.objects.filter(keyname=keyname).first()
    #return dataclass

    if not keyname in cache.cache_classname:
        cache.cache_classname[keyname] = DataClass.objects.filter(keyname=keyname).first()
    return cache.cache_classname[keyname]


def local_get_instances(classobj = None, is_enabled=None):
    ''' class keyname => Queryset'''

    #dataclass = get_class_by_name(classname)
    if is_enabled:
        instances = DataInstance.objects.filter(classobj=classobj, is_enabled=is_enabled).select_related('classobj')
    else:
        instances = DataInstance.objects.filter(classobj=classobj).select_related('classobj')
    return instances


def local_get_instances_from_keylist(classobj = None, keylist=[], is_enabled=None):
    ''' class keyname => Queryset'''

    if is_enabled:
        instances = DataInstance.objects.filter(classobj=classobj, keyname__in=keylist, is_enabled=is_enabled).select_related('classobj')
    else:
        instances = DataInstance.objects.filter(classobj=classobj, keyname__in=keylist).select_related('classobj')
    return instances


def local_get_instance_by_name(iname=None, classobj=None, classname=None):
    
    if not classobj:
        classobj = local_get_class_by_name(classname)
    iobj = DataInstance.objects.filter(classobj=classobj, keyname=iname).select_related('classobj').first()
    return iobj

# -------------
#  SCHEMA
# -------------
class FieldSchema(Field):



    def get_classname(self):        
        ''' dataformat_ext: classname inject1 inject2 ...'''
        try:
            return self.dataformat_ext.split()[0]
        except:
            return ""


    def get_eav_format(self):
        # schema:classname
        c = self .get_classname()
        return f"schema:{c}"



    def get_subfields(self):
        ''' dataformat_ext: classname inject1 inject2 ...'''
        try:
            return self.dataformat_ext.split()[1:]
        except:
            return []


    def get_first_value(self):
        ''' name of first target instance'''
        try:
            return self.value[0]
        except:
            return
        

    def get_attribute(self):
        ''' returns list of DB obj '''

        reply = []
        classname = self.get_classname()

        for iname in self.value:
            iobj = local_get_instance_by_name(iname=iname, classname=classname)
            reply.append(iobj)
        return reply


    def get_datapoint_ui_detail(self):
        ''' 
        Returns list of datapoints [ {}, {}, ...]
        datapoint["value"] = [ { key:, display:, }  , ... ]
        '''
        # self.value = [keyname1, keyname2, ...]

        datapoint = super().get_datapoint_ui_detail()

        datapoint["value"] = []

        #classname = datapoint["dataformat_ext"]
        classname = self.get_classname()
        datapoint["schema"] = classname
        classobj = local_get_class_by_name(classname)
        if not classobj:
            return datapoint


        # use cache for single value
        if len(self.value) == 1:

            # NEXT : merge with cache.cache_instance_name from DATA get_instance_by_name
            # key = f"{classobj.keyname}::{iname}"
            # if key not in cache.cache_instance_name:            
            # obj = DataInstance.objects.filter(classobj=classobj, keyname=iname).select_related('classobj').first()
            ckey = f"{classobj.keyname}::{self.value[0]}"

            if ckey in cache.cache_fieldschema_detail:
                dp = cache.cache_fieldschema_detail[ckey]
                datapoint["value"] = dp
            else:
                instances = DataInstance.objects.filter(classobj=classobj, keyname__in=self.value).values("id","keyname","displayname")
                for i in instances:
                    item = { "key":i["keyname"], "display":i["displayname"],  "id":i["id"] }
                    datapoint["value"].append(item)
                cache.cache_fieldschema_detail[ckey] = datapoint["value"]



        else:
            #instances = DataInstance.objects.filter(classobj=classobj, keyname__in=self.value).select_related('classobj')
            instances = DataInstance.objects.filter(classobj=classobj, keyname__in=self.value).values("id", "keyname","displayname")
            for i in instances:
                item = { "key":i["keyname"], "display":i["displayname"], "id":i["id"] }
                datapoint["value"].append(item)

        return datapoint        



    def get_datapoint_ui_edit(self):

        # value: [ { 'key':'keyname' , 'selected':True/False }, ...    ]

        datapoint = super().get_datapoint_ui_edit()

        datapoint["value"] = []

        #classname = datapoint["dataformat_ext"]
        classname = self.get_classname()
        datapoint["dataformat_ext"] = classname

        classobj = local_get_class_by_name(classname)
        if not classobj:
            return datapoint
        
        count = classobj.datainstance_set.count()
        bigset_size = int(get_configuration("data","DATA_BIGSET_SIZE"))
        if count > bigset_size:
            datapoint["bigset"] = True
        else:
            datapoint["bigset"] = False

        # bigset : selected items only (ajax for the rest)
        if datapoint["bigset"]:
            limited_instances_obj = local_get_instances_from_keylist(classobj=classobj, keylist=self.value, is_enabled=True)
            for i in limited_instances_obj:
                selected = True
                item = { "key":i.keyname, "display":i.displayname, "selected":selected}
                datapoint["value"].append(item)
            # selected = False
            # item = { "key":"test03232", "selected":selected}
            # datapoint["value"].append(item)


        # no bigset : all available and selected items
        else:
            all_instances_obj = local_get_instances(classobj=classobj, is_enabled=True)
            for i in all_instances_obj:
                if i.keyname in self.value:
                    selected = True
                    # item = { "key":i.keyname, "selected":selected}
                    # datapoint["value"].append( item )
                else:
                    selected = False
                item = { "key":i.keyname, "display":i.displayname, "selected":selected }
                datapoint["value"].append( item )

        return datapoint        


    def is_valid(self):
        r = super().is_valid()
        # TODO
        return r