# (c) cavaliba.com - test_user.py

import yaml

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse

from app_home.configuration import get_configuration

from app_data.models import DataClass
from app_data.models import DataSchema
from app_data.models import DataInstance

from app_user.models import SireneUser
from app_user.models import SireneGroup
from app_user.models import SirenePermission


from app_user.user import user_get_login_by_email
from app_user.user import user_get_by_login

from app_user.group import group_get_by_id
from app_user.group import group_get_by_name
from app_user.group import group_get_by_data
from app_user.group import group_delete
from app_user.group import group_get_users

import app_home.cache as cache
from app_data.loader import load_broker




# autogroup
class Autogroup(TestCase):
  
    def setUp(self):
        cache.init()

        datalist = yaml.safe_load('''
            - classname: _user
              keyname: user1
              email: user1@test.test

            - classname: _user
              keyname: user2
              email: user2@test.test

            - classname: _user
              keyname: user3
              email: user3@test.test

            - classname: _user
              keyname: user4
              email: user4@test.test

            - classname: _user
              keyname: user5
              email: user5@test.test

            - classname: _user
              keyname: user6
              email: user6@test.test

            - classname: _user
              keyname: user99
              email: user99@test.test
                                                                    
                                                                                                      
            - classname: _schema
              keyname: site
              manager:
                  displayname: manager
                  dataformat: user
              accountant:
                  displayname: accountant
                  dataformat: user

                                              
            - classname: site
              keyname: site1
              manager: 'user1'
              accountant: 'user2'
                                  
            - classname: site
              keyname: site2
              manager: 'user3'
              accountant: 'user4'
                                  
            - classname: site
              keyname: site3
              manager: 'user5'
              accountant: 'user6'

                                                                                                      
            - classname: _group
              keyname: group1
              users : ['user99']

            - classname: _group
              keyname: group2
              autogroup: 'site:*:manager'
              users : ['user99']

            - classname: _group
              keyname: group3
              autogroup: 'site:site1:*'
              users : ['user99']
                                                                    
                                  
            ''')
        
        aaa = {'perms':['p_group_create', 'p_user_create', 
                        'p_schema_create',
                        'p_schemafield_create','p_schemafield_read','p_schemafield_update',
                        'p_data_admin']
                        }
        r = load_broker(datalist=datalist, aaa=aaa, verbose=False)





    def test_no_grammar(self):

        user = user_get_by_login('user99')
        self.assertIsNotNone(user)

        group1 = group_get_by_name('group1')
        self.assertIsNotNone(group1)

        users = group_get_users(group1)
        self.assertEqual(len(users), 1)
        self.assertIn(user, group1.users.all())




    def test_g1_grammar(self):

        group = group_get_by_name('group2')
        self.assertEqual(group.autogroup, 'site:*:manager')

        users = group_get_users(group)
        self.assertEqual(len(users), 4)

        user1 = user_get_by_login('user1')
        user3 = user_get_by_login('user3')
        user5 = user_get_by_login('user5')
        user99 = user_get_by_login('user99')

        self.assertIn(user99, users)
        self.assertIn(user1, users)
        self.assertIn(user3, users)
        self.assertIn(user5, users)


    def test_g2_grammar(self):


        group = group_get_by_name('group3')
        self.assertEqual(group.autogroup, 'site:site1:*')

        users = group_get_users(group)
        self.assertEqual(len(users), 3)

        user1 = user_get_by_login('user1')
        user2 = user_get_by_login('user2')
        user99 = user_get_by_login('user99')

        self.assertIn(user99, users)
        self.assertIn(user1, users)
        self.assertIn(user2, users)


