# (c) cavaliba.com - data - exporter.py

import yaml
import json

from django.http import HttpResponse
from django.forms.models import model_to_dict


from .data import get_classes

from .data import Instance

# export JSON / YAML / CSV instances


# --------------------------------------------------------
#  Exporter 
# --------------------------------------------------------


# from cli
def listdict_class_export(classes=None, keyname=None, first=0, last=9999999999):

    datalist = []

    if not classes:
        classes = get_classes()

    for classname in classes:
        
        if keyname:
            instance = Instance.load_from_names(classname=classname, keyname=keyname)
            if instance:
                data = instance.get_dict_for_export()
                datalist.append(data)
        else:
            for instance in Instance.iterate_classname(classname=classname, first=first, last=last):
                data = instance.get_dict_for_export()
                datalist.append(data)


    return datalist




# #YAML
# class MyYamlDumper(yaml.SafeDumper):
#     def write_line_break(self, data=None):
#         super().write_line_break(data)
#         if len(self.indents) < 2:
#             super().write_line_break()

# def data_yaml_response(classes=None):
#     datalist = listdict_class_export(classes=classes)
#     filedata = yaml.dump(datalist, allow_unicode=True, Dumper=MyYamlDumper, sort_keys=False)
#     response = HttpResponse(filedata, content_type='text/yaml')  
#     response['Content-Disposition'] = 'attachment; filename="data.yaml"'
#     return response

# # JSON
# def data_json_response(classes=None):
#     datalist = listdict_class_export(classes=classes)
#     filedata = json.dumps(datalist, indent=4, ensure_ascii=False)
#     response = HttpResponse(filedata, content_type='text/json')  
#     response['Content-Disposition'] = 'attachment; filename="data.json"'
#     return response
