# app_status - models.py

from django.db import models

from datetime import datetime
from datetime import timedelta

from django.utils import timezone
from django.utils.translation import gettext_lazy as _





class StatusRaw(models.Model):

    timestamp    = models.DateTimeField("Timestamp", auto_now_add=True)
    monitor      = models.CharField("Monitor", max_length=128, null=False, blank=False)
    status       = models.BooleanField("Status", default=False)
    usec         = models.IntegerField("usec", default=0)
    data         = models.TextField("Data", max_length=5000,  null=True, blank=True)

    class Meta:
        db_table = "status_raw"
        indexes = [
            models.Index(fields=["timestamp"]),
            models.Index(fields=["monitor"]),
            ]
        ordering = ['timestamp']
        verbose_name = "Status Raw"
        verbose_name_plural = "Status Raw"

    def __str__(self):
        return f"{self.timestamp} - {self.monitor} - {self.status}"




class StatusSampleHour(models.Model):

    timestamp    = models.DateTimeField("Timestamp", auto_now_add=False)
    monitor      = models.CharField("Monitor", max_length=128, null=False, blank=False)
    count_ok     = models.IntegerField("OK", null=True, blank=True)
    count_ko     = models.IntegerField("KO", null=True, blank=True)

    class Meta:
        db_table = "status_sample_hour"
        indexes = [
            models.Index(fields=["timestamp"]),
            models.Index(fields=["monitor"]),
            ]
        ordering = ['timestamp']
        verbose_name = "Status Sample Hour"
        verbose_name_plural = "Status Sample Hour"

    def __str__(self):
        return f"{self.timestamp} - {self.monitor}"


class StatusSampleDay(models.Model):

    timestamp    = models.DateTimeField("Timestamp", auto_now_add=False)
    monitor      = models.CharField("Monitor", max_length=128, null=False, blank=False)
    count_ok     = models.IntegerField("OK", null=True, blank=True)
    count_ko     = models.IntegerField("KO", null=True, blank=True)

    class Meta:
        db_table = "status_sample_day"
        indexes = [
            models.Index(fields=["timestamp"]),
            models.Index(fields=["monitor"]),
            ]
        ordering = ['timestamp']
        verbose_name = "Status Sample Day"
        verbose_name_plural = "Status Sample Day"

    def __str__(self):
        return f"{self.timestamp} - {self.monitor}"
