# (c) cavaliba.com - test_data 

import yaml 

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse

from app_home.configuration import get_configuration

import app_home.cache as cache

from app_data.models import DataClass
from app_data.models import DataSchema
from app_data.models import DataInstance
from app_data.models import DataEAV

from app_data.data import Instance
from app_data.loader import load_broker

from app_data.fieldtypes.field_ipv4 import FieldIPV4
from app_data.fieldtypes.field_float import FieldFloat
from app_data.fieldtypes.field_int import FieldInt




class TestDataEAV(TestCase):
    
    fixtures = ["test"]

    def setUp(self):
        cache.init()
        
    def test_eav_fixture(self):

        eavobj = DataEAV.objects.filter(
            classname = 'test1', 
            keyname = 'test1-01',
            fieldname = 'myipv4',
            ).first()
        
        self.assertEqual(eavobj.format , 'ipv4')
        self.assertEqual(eavobj.value , '10.1.2.3')


    def test_eav_insert(self):

        instance = Instance.new_from_names(classname = 'test1', keyname ='test_eav')
        instance.create()
        self.assertEqual(instance.is_bound,True)

        eavobj = DataEAV.objects.filter(classname = 'test1', keyname = 'test_eav').all()
        self.assertTrue(len(eavobj) > 0)


    def test_eav_delete(self):

        instance = Instance.load_from_names(classname = 'test1', keyname ='test1-01')
        instance.delete()
        self.assertEqual(instance.is_bound,False)

        eavobj = DataEAV.objects.filter(classname = 'test1', keyname = 'test1-01').all()
        self.assertTrue(len(eavobj) == 0)
