# (c) cavaliba.com - test_data_revision.py

import yaml

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse

from app_home.configuration import get_configuration
import app_home.cache as cache
from app_data.loader import load_broker

from app_data.models import DataRevision
from app_data.revision import revision_add
from app_data.revision import revision_add_raw
from app_data.revision import revision_get
from app_data.revision import revision_purge

class TestDataRevision(TestCase):
  
    def setUp(self):
        cache.init()


    def test_revision_add_raw(self):
        revision_add_raw(aaa=None, classname="classtest", keyname="keytest", action="test")
        count = DataRevision.objects.count()
        self.assertEqual(count,1)

    def test_revision_get(self):
        revision_add_raw(aaa=None, classname="classtest", keyname="keytest", action="test")
        revqs = revision_get(classname="classtest", keyname="keytest")
        self.assertEqual(len(revqs),1)

    def test_revision_purge(self):
        count = revision_purge()
        self.assertEqual(count,0)

    # TODO
    # revision_add
    # client view edit instance/user/group/role => see Revision entry
    # client view detail => Revision dropdwon content
