# tests app_sirene

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse


from app_home.configuration import get_configuration
from app_home.models import CavalibaConfiguration

from app_user.aaa import get_aaa

from app_user.models import SireneUser, SireneGroup
from app_user.group import group_get_by_name
from app_user.role import role_get_by_name


from app_sirene.models import SMSJournal

from app_sirene.sms import sms_check_valid_number


# --------------------------------------------------
# SMS function
# --------------------------------------------------
class SMSTest(TestCase):

    def test_sms_regexp(self):
        
        r = sms_check_valid_number("123456789")
        self.assertTrue(r)

        r = sms_check_valid_number("+(465) 323 44 55 66 77 88")
        self.assertTrue(r)

        r = sms_check_valid_number("")
        self.assertFalse(r)

        r = sms_check_valid_number("a")
        self.assertFalse(r)

# --------------------------------------------------
# NEXT
# --------------------------------------------------

# from app_sirene.models import MessageTemplate
# from app_sirene.models import Message
# from app_sirene.models import Site
# from app_sirene.models import SiteGroup
# from app_sirene.models import App


# class ModelTest(TestCase):

#     fixtures = ["test_data.json"]


#     # @classmethod
#     # def setUpTestData(cls):
#     #     super().setUpClass()
#     #     # Set up non-modified objects used by all test methods
#     #     Site.objects.create(name='site1', description='description_site1')
#     #     SiteGroup.objects.create(name='sitegroup1', description='description_sitegroup1')
#     #     App.objects.create(name='app1', description='description_app1')
#     #     SireneUser.objects.create(login='user1', description='description_user1')
#     #     SireneUserGroup.objects.create(name='group1', description='description_group1')
        

#     def test_model_site(self):
#         #site = Site.objects.get(name="site")
#         #Site.objects.create(name='site1', description='description_site_1')
#         #site = Site(name="site2", description="description_site_2")
#         #site.save()
#         site = Site.objects.get(name="site01")
#         #print(site.id)
#         #self.assertIsNotNone(site.id)
#         self.assertEquals(site.name,"site01")
#         # field_label = site._meta.get_field('name').verbose_name
#         # self.assertEquals(field_label, 'name')

#     def test_model_sitegroup(self):
#         item = SiteGroup.objects.get(name="sitegroup01")
#         self.assertEquals(item.name,"sitegroup01")

#     def test_model_sitegroup_addsite(self):
#         sitegroup  = SiteGroup.objects.get(name="sitegroup01")
#         site = Site.objects.get(name="site05")
#         sitegroup.sites.add(site)
#         sitegroup.save()
#         a = sitegroup.sites.count()
#         self.assertEquals(a,3)



