# tests app_sirene_operator

from django.test import TestCase, override_settings
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django


import app_home.cache as cache
from app_home.configuration import get_configuration
from app_user.models import SireneUser
from app_user.models import SireneGroup
from app_user.role import role_get_by_name


# --------------------------------------------------
# Sirene Operator 
# --------------------------------------------------

class AppSireneOperatorTest(TestCase):

    fixtures = ["test"]


    def setUp(self):
        cache.init()
        cache_django.clear()

        user = SireneUser.objects.create(login="unittest", firstname="unittestname")
        user.save()

        role = role_get_by_name("role_sirene_operator")
        role.users.add(user)
        role.save()

    def tearDown(self):
        # super().tearDown()
        cache_django.clear()

        

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_auth_mode_and_role(self):
        r = get_configuration("env", "CAVALIBA_AUTH_MODE")
        self.assertEqual(r, 'unittest')


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_public(self):
        response = self.client.get(reverse('app_sirene:index'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_anonymous(self):
        response = self.client.get(reverse('app_sirene:anonymous'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_private(self):
        response = self.client.get(reverse('app_sirene:private'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_archive(self):
        response = self.client.get(reverse('app_sirene:archive'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_smsjournal(self):
        response = self.client.get(reverse('app_sirene:sms_journal'))
        self.assertEqual(response.status_code, 200)



# -- flush all GET/POST
    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_flushall_get(self):
        response = self.client.get(reverse('app_sirene:flushall'), follow=True)
        #self.assertEqual(response.status_code, 302)
        a = ('/sirene/', 302)
        #print(response.redirect_chain)
        self.assertTrue( a in response.redirect_chain)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_operator_flushall_post(self):
        response = self.client.post(reverse('app_sirene:flushall'), follow=True)
        a = ('/sirene/private/', 302)
        #print(response.redirect_chain)
        self.assertTrue( a in response.redirect_chain)

