---
title: json
description: FieldType JSON
weight: 242
---

Stores structured data in JSON (JavaScript Object Notation) format for complex nested data structures.

## dataformat: text

JSON fields are implemented as text fields with a special extension.

```yaml
  MYFIELD:
      dataformat: text
      dataformat_ext: json
```

## dataformat_ext

**Required**: `json`

The `dataformat_ext: json` specifies that the text field should be treated and displayed as JSON. This enables JSON syntax highlighting, validation, and appropriate UI handling.

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: application
  config:
    dataformat: text
    dataformat_ext: json
    displayname: Configuration
    description: Application configuration as JSON
```

### Instance Example

```yaml
- classname: application
  keyname: app1
  config: |
    {
      "debug": false,
      "timeout": 30,
      "features": {
        "cache": true,
        "logging": true
      }
    }
```

## Notes

- Full JSON syntax supported (objects, arrays, strings, numbers, booleans, null)
- No schema validation - any valid JSON accepted
- Useful for storing flexible or evolving data structures
- Can be queried and manipulated with JSON functions
- Large JSON structures supported (no size limit as of v3.21.0+)
- Consider data normalization if structure becomes very complex
