---
title: Reverse-Proxy and TLS/SSL
description: Add a Reverse-Proxy and offload SSL/TLS
weight: 890
---

You should setup a TLS/SSL reverse-proxy in front of your Cavaliba docker deployment.

A reverse-proxy would perform the following tasks:

* offload (terminate) HTTPS SSL/TLS user connections and handle certificate configuration and renewal
* filter user source IP addresses if restricted network exposure is needed
* perform HTTP Basic/Digest user authentication if this auth mode is selected for Cavaliba
* produce log and audit-trail
* on large / fault-tolerant setups, perfom user trafic load-balancing accross multiple Cavaliba nodes
* display a Maintenance/Sorry page if it detects that cavalliba stack is down

You may use an enterprise wide / netork managed load-balancer and reverse-proxy. You can also deploy a small NGINX or HA-PROXY component on your Cavaliba host virtual machine.



## Node Healthcheck / status

An external reverse-proxy or load-balancer should remove a failed node from its server pool and stop sending user traffic to failed nodes.

Additionally, a monitoring tool should check the availability of services.

Basic healthcheck can be implemented by verifying a simple TCP on http endpoint (TCP can connect). you can also check an HTTP 200 response.

Better, you may implement a deeper healthcheck on the  **/status/** page and check for an "OK" answer from Cavaliba. This check confirms that the application node is alive and healthy.

    curl http://cavaliba/status/
	OK


## Example : minimal NGINX / Let's Encrypt SSL/TLS reverse-proxy

Setup
```
$ sudo apt install nginx apache2-utils certbot python3-certbot-nginx
$ sudo certbot -n --agree-tos --email mycontact@mydomain.com --nginx -d mycavaliba.mydomain.com
$ sudo systemctl enable nginx
```

Configuration
```
$ sudo cat /etc/nginx/sites-enabled/default

	upstream cavaliba {
	  keepalive 60;
	  server 127.0.0.1:8000;
	}
	server
	{
	    if ($host = mycavaliba.mydomain.com ) {
	        return 301 https://$host$request_uri;
	    } # managed by Certbot
	    listen 80 default_server;
	    server_name mycavaliba.mydomain.com;
	    return 404; # managed by Certbot
	}
	server
	{
	    server_name mycavaliba.mydomain.com;
	    listen 443 ssl; # managed by Certbot
	    ssl_certificate /etc/letsencrypt/live/mycavaliba.mydomain.com/fullchain.pem; # managed by Certbot
	    ssl_certificate_key /etc/letsencrypt/live/mycavaliba.mydomain.com/privkey.pem; # managed by Certbot
	    include /etc/letsencrypt/options-ssl-nginx.conf; # managed by Certbot
	    ssl_dhparam /etc/letsencrypt/ssl-dhparams.pem; # managed by Certbot

	    # -------------
	    location /
	    {
	        proxy_set_header Host $http_host;
	        proxy_set_header X-Forwarded-Host $host;
	        proxy_set_header X-Forwarded-Server $host;
	        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
	        #rewrite ^/cavaliba/(.*)$  /$1  break;
	        proxy_pass http://cavaliba;
	        proxy_http_version 1.1;
	        proxy_set_header Connection "";
	    }
	}
```