# (c) cavaliba.com - data - admin.py

from django.contrib import admin

from app_data.models import DataClass
from app_data.models import DataSchema
from app_data.models import DataInstance
from app_data.models import DataRegistry
from app_data.models import DataEAV
from app_data.models import DataFile
from app_data.models import DataRevision

@admin.register(DataClass)
class DataClassAdmin(admin.ModelAdmin):
   list_display = ('keyname', 'displayname', 'is_bigset', 'order', 'page', 'p_read', 'id')
   ordering=["keyname"]
   list_filter = ["page"]

@admin.register(DataSchema)
class DataSchemaAdmin(admin.ModelAdmin):
   list_display = ('classname', 'keyname', 'displayname', 'dataformat', 'dataformat_ext', 'default_value', 
      'cardinal_min', 'cardinal_max', 'page', 'order', 'id')
   ordering=["classname", "order", "keyname"]
   list_filter = ["classname","dataformat"]


@admin.register(DataInstance)
class DataInstanceAdmin(admin.ModelAdmin):
   list_display = ('classname', 'keyname', 'displayname', 'is_enabled', 'p_read', 'last_update', 'id')
   #ordering=["classname","keyname"]
   ordering=["-last_update"]
   list_filter = ["classname"]


# DataRegistry
@admin.register(DataRegistry)
class DataRegistryAdmin(admin.ModelAdmin):
   list_display = ('key', 'value', 'id')

# DataEAV
@admin.register(DataEAV)
class DataEAVAdmin(admin.ModelAdmin):
   list_display = ('iid','classname', 'keyname', 'displayname', 'fieldname', 'format', 'value' , 'last_update','id')
   ordering=["id"]
   list_filter = ["classname","format","fieldname"]


# DataFile
@admin.register(DataFile)
class DataFileAdmin(admin.ModelAdmin):
   list_display = ('fileid', 'filename', 'filepath', 'displayname', 'size', 'is_enabled', 'last_update','id')
   ordering=["-id"]
   #list_filter = ["is_enabled", "is_encrypted"]

# DataRevision 3.23
@admin.register(DataRevision)
class DataRevisionAdmin(admin.ModelAdmin):
   list_display = ('date', 'classname', 'keyname', 'username', 'action','id')
   ordering=["-id"]
   #list_filter = ["is_enabled", "is_encrypted"]   