# (c) cavaliba.com - data - search.py

import re
from django.db.models import Q

from .models import DataInstance
#from .data import Instance



def get_query_from_request(request=None, classname=None, update_session=False):

    if not request:
        return None
    
    if not classname:
        return None
    
    
    query = None

    # GET request => session or blank
    if request.method == "GET":
        try:
            return request.session["query"][classname]
        except:
            return None      
    
    # POST request : store in session if valid
    elif request.method == "POST":
        query = request.POST.get('query', None)
        m = re.compile(r'^[a-zA-Z0-9()_\/\.\s]*$')
        if not m.match(query):
            query = ""

        if update_session:
            if "query" not in request.session:
                request.session["query"] = {classname: query}
                #request.session.modified = True
            else:
                request.session["query"][classname] = query
                request.session.modified = True

    return query



def get_instance_from_query(query=None, classname=None, offset=None, limit=None):

    if not classname:
        return
    
    if not query:
        query = ""

    if not offset:
        offset = 0

    if limit:
        try:
            int(limit)
            if limit <= 0:
                return
        except:
            return



    if len(query) > 0:
        qc = Q(classname=classname)
        q= Q()
        for item in query.split():
            q |= Q(keyname__icontains=item)
            q |= Q(displayname__icontains=item)
            q |= Q(data_json__icontains=item)
    
        if limit:
            instances = DataInstance.objects.filter(qc & q)[offset:limit]
        else:
            instances = DataInstance.objects.filter(qc & q)[offset:]


    else:
        if limit:
            instances = DataInstance.objects.filter(classname=classname)[offset:limit]
        else:
            instances = DataInstance.objects.filter(classname=classname)[offset:]


    return instances



