---
title: Tutorial
description: Learn by doing
weight: 20
draft: false
---


## Tutorial - Learn by doing

For those who learn best by doing, this tutorial is for you.

In this section we will go through a multi-step tutorial to explore various features of Cavaliba, from simple designs to more advanced. 

Most steps are also provided as configuration files, already available within the Docker image. You'll see how to load each of the tutorial steps if you want to skip some sections, while keeping in sync with the rest of the tutorial.

## In a hurry ? Want to see the whole result now ?

You can skip the tutorial and load the complete result with these commands: 

    $ cd /my/folder/with/cavaliba
    $ docker exec -it cavaliba_app python manage.py cavaliba load builtin/demo/

    or with the recommended alias in the Getting Started / Useful Commands section:

    $ cd /my/folder/with/cavaliba
    $ cavaliba load builtin/demo/


If you don't know how to proceed, well, the tutorial might definitely be a good start.


## Tutorial objective

Organize Asset and resource management for fictional CavCorp company: business assets (stores, stocks, factories), organization, people, customers, IT systems, Project Portfolio, Contracts, Suppliers, and more.


Those inventory are currently spread in various documents or systems, such as redundant and different spreadsheets with poor naming conventions, obsolete information, isolated or non-connected business information between topics, and unknown security rules regarding access and modification.


You'll learn how to interact with the Web User Interface (UI) as some CavCorp users would probably do.

To get Data in and out in large quantity with external existing systems at CavCorp, you'll define import/export connectors and data transformation pipelines. 

Security and permissions will be part of our journey to implement role and authorization to secure data access and modification as well as logging various data management activities.

Finally, we will explore some of the included services in Cavaliba such as Incident Response, User Notifications or IT Application StatusPage.

By the end, you should have a working solution, and more important, a solid taste of Cavaliba features.









