---
title: text
description: FieldType Text
weight: 241
---

Represents longer formatted text content with support for rich text (HTML/TinyMCE editor) or plain text.

## dataformat: text

```yaml
  MYFIELD:
      dataformat: text
      default: ""
```

## dataformat_ext

**Not used** - Text fields have no extended options. All text content is handled uniformly through the TinyMCE editor.

## Characteristics

- **Longer content**: Designed for multi-line, paragraph-length text
- **Rich text support**: TinyMCE editor for HTML formatting in UI
- **Flexible**: Can store plain text or HTML
- **Single-value**: Does not support multi-value (cardinal_max is fixed)

## Multivalue

**Not supported** - Each text field holds one text block.

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: article
  body:
    dataformat: text
    displayname: Article Body
    description: Main article content
```

### Instance Example

```yaml
- classname: article
  keyname: article001
  body: "This is the main content of the article with multiple paragraphs..."
```

## Notes

- Designed for long-form content (use `string` for short single-line text)
- Supports HTML formatting and markup
- TinyMCE editor provides visual editing in UI
- Useful for documentation, templates, descriptions, comments
- Single-value field (no multi-value support)
- Can include Markdown, HTML, or plain text
