# (c) cavaliba.com - tests /data / cache

from django.test import override_settings
from django.test import TestCase
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django
from django.core.management import call_command

from tests import helper

import app_home.cache as cache
from app_data.models import DataEAV
from app_data.data import Instance


class TestDataEAV(TestCase):

    fixtures = ["test"]

    def setUp(self):
        cache.clear()

    def test_eav_fixture(self):

        eavobj = DataEAV.objects.filter(
            classname='test1',
            keyname='test1-01',
            fieldname='myipv4',
        ).first()

        self.assertEqual(eavobj.format, 'ipv4')
        self.assertEqual(eavobj.value, '10.1.2.3')

    def test_eav_insert(self):

        instance = Instance(classname='test1', keyname='test_eav')
        instance.create()
        self.assertEqual(instance.is_bound, True)

        eavobj = DataEAV.objects.filter(
            classname='test1', keyname='test_eav').all()
        self.assertTrue(len(eavobj) > 0)

    def test_eav_delete(self):

        instance = Instance.from_keyname(classname='test1', keyname='test1-01')
        instance.delete()
        self.assertEqual(instance.is_bound, False)

        eavobj = DataEAV.objects.filter(
            classname='test1', keyname='test1-01').all()
        self.assertTrue(len(eavobj) == 0)
