---
title: Schema
description: Schema
weight: 201
---

**Schema** are definitions of top-level asset families : Devices, Applications, Laptops, Projects, Customers, Books, Facilities, Cooking Receipes, Invoices, etc.

## Create a simple Schema

To manage laptops (for example), you can define a simple Schema:

```yaml files/import/laptop.yaml
- classname: _schema
  keyname: laptop
  displayname: User Laptops      
```

Go to the import tool from the left sidebar, and paste this YAML snippet. 
Clic on import. You can now manage `laptops` 
objects from the UI.

You can also use the `CLI` command :
```bash
$ cavaliba load files/import/laptop.yaml
```


To create a first laptop object in the new Schema, either use the Web UI (edit), or import the following YAML snippet:

```yaml
- classname: laptop
  keyname: pc0001
  displayname: Evan's laptop      
```


## Schema Reference

```yaml

- classname: _schema
  _action: create/delete/update/enable/disable
  keyname: string
  displayname: string
  is_enabled: boolean
  order: int
  page: string

  _options:

      p_admin:  PERMISSION_NAME
      p_read:   PERMISSION_NAME
      p_create: PERMISSION_NAME
      p_update: PERMISSION_NAME
      p_delete: PERMISSION_NAME
      p_import: PERMISSION_NAME
      p_export: PERMISSION_NAME


      keyname_mode: edit(*) |  auto
      keyname_label: STRING
      displayname_label: STRING
      icon: ICON (ex. fa-question)


  FIELDNAME1:
      (...)
   
```



## Reserved Schema names

Some internal/builtin schema names are reserved and are not available for user-defined schemaes:

- _schema
- _user
- _group
- _role
- _permission
- _apikey
- _enumerate
- _dataview


## Builtin Fields

All  Schema share a small number of builtin fields.

- **keyname** - primary key - unique name of the Schema ; no special chars ; must be unique. Some options exists to hide/auto-generate keyname if a user friendly value is not needed.
- **displayname** - a short label for humans to read
- **is_enabled** - true/false ; disabled objects are not available to regular users.
- **_options** - dictionary of Schema options. See below
- **page** - string, page name in the Web UI displaying the list of available DataClasses
- **order** - int, display order in the Web UI


## Schema _options

- **icon** - string, name of a FontAwsome Icon to display in UI
- **permissions...** - a set of permissions to control authorizations on instances
- **keyname_label** : User friendly label for builtin keyname field.
- **keyname_mode** : either edit (default) or auto (automatic uuid string)
- **displayname_label** : User friendly label for builtin displayname field.



## Schema Fields

Each Schema can have zero or more custom fields. These fields can be single-valued or multi-valued. They have a type from one of the available field types.

Field name must be a valid slug string (unique, no special character) within the Schema. 


See [Field Types](/docs/data/fieldtypes)

## Schema Example

This example create a Schema to manage user Laptops.

```yaml
# Asset = User Laptops

- classname: _schema
  keyname: laptop
  displayname: User Laptops
  is_enabled: yes
  order: 200
  page: Data

  _options:
     icon: fa-laptop

  serial:
        displayname: serial_number
        page: General
        order: 100
        dataformat: string
               
  name:
        displayname: hostname
        page: General
        order: 110
        dataformat: string

  os:
        displayname: Operating System
        page: General
        order: 120
        dataformat: enumerate
        dataformat_ext: enumerate_os

  site:      
        displayname: Site
        dataformat: schema
        dataformat_ext: site
        order: 130
        page: General
        cardinal_min: 0
        cardinal_max: 1 

  owner:      
        displayname: User
        dataformat: user
        order: 140
        page: General
        cardinal_min: 0
        cardinal_max: 0

  purchase_date:
        displayname: Purchase date
        dataformat: date

  waranty_end_date:
        displayname: Waranty end date
        dataformat: date

  bitlocker:
        displayname: Bitlocker
        page: Security
        order: 500
        dataformat: boolean

```
