---
title: role
description: FieldType Role
weight: 232
---

References one or more Cavaliba roles. Allows assigning permissions and responsibilities through role definitions.

## dataformat: role

```yaml
  MYFIELD:
      dataformat: role
```

## dataformat_ext

**Not used** - Role fields have no extended options. The field automatically references all roles in the system.

## Values

Field contains role identifiers as strings. References SireneRole objects in the system.

## Multivalue

Multi-value is supported for assigning multiple roles.

```yaml
## SCHEMA
MYROLES:
      dataformat: role
      cardinal_max: 0

## INSTANCE multi-valued
  MYROLES: [editor, reviewer, admin]
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: person
  primary_role:
    dataformat: role
    displayname: Primary Role
    description: Primary role assignment
```

### Instance Example

```yaml
- classname: person
  keyname: john_smith
  primary_role: developer
```

## Role Structure

Roles contain:
- **Permissions**: Granular permissions (e.g., `p_data_create`, `p_data_read`)
- **Hierarchy**: Can be organized hierarchically (e.g., admin > editor > viewer)
- **Purpose**: Define what users can do in the system

## Relationship to Users and Groups

- Users can have roles directly
- Groups can contain users with specific roles
- Combined with SireneGroup for team-based access control
- Used in API authentication (e.g., APIKey schema)

## Notes

- References actual roles in the IAM system (SireneRole model)
- Roles bundle multiple permissions together
- Useful for permission management and access control
- Related to the AAA (Authentication, Authorization, Accounting) system
- Can define hierarchy and inheritance of permissions
- Commonly used in API keys for access control
