# (c) cavaliba.com - tests / api

from django.test import override_settings
from django.test import TestCase
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django

from tests import helper

import app_home.cache as cache
from app_data.data import Instance


class APIKeyTest(TestCase):

    fixtures = ["test"]

    def setUp(self):
        cache.clear()

        instance = Instance(classname="_apikey", keyname="key1")
        data = {
            "keyvalue": "secret1",
            "ip_filter": "*",
            "is_readonly": True,
            "is_enabled": True,
            "roles": ["role_api_read"],
            "permissions": []
        }
        instance.merge_import(data)
        instance.create()

        instance = Instance(classname="_apikey", keyname="key2")
        data = {
            "keyvalue": "secret2",
            "ip_filter": "*",
            "is_readonly": False,
            "is_enabled": True,
            "roles": ["role_api_admin"],
            "permissions": []
        }
        instance.merge_import(data)
        instance.create()

    def test_auth_nokey(self):
        # no key
        response = self.client.get(reverse('app_data:api_index'))
        self.assertEqual(response.status_code, 401)

    def test_auth_goodkey(self):
        response = self.client.get(
            reverse('app_data:api_index'),
            headers={"X-Cavaliba-Key": "key1 secret1"},
        )
        self.assertEqual(response.status_code, 200)

    def test_auth_keyoff(self):
        # key OFF
        instance = Instance(classname="_apikey", keyname="koff")
        data = {
            "keyvalue": "ktest",
            "ip_filter": "*",
            "is_readonly": False,
            "is_enabled": False,
        }
        instance.merge_import(data)
        instance.create()

        response = self.client.get(
            reverse('app_data:api_index'),
            headers={"X-Cavaliba-Key": "koff ktest"},
        )
        self.assertEqual(response.status_code, 401)

    def test_auth_badpwd(self):
        response = self.client.get(
            reverse('app_data:api_index'),
            headers={"X-Cavaliba-Key": "key1 badsecret"},
        )
        self.assertEqual(response.status_code, 401)

    def test_auth_ro_ko(self):

        response = self.client.post(
            reverse('app_data:api_index'),
            headers={"X-Cavaliba-Key": "key1 secret1"},
        )
        self.assertEqual(response.status_code, 401)

    def test_auth_rw_ok(self):

        response = self.client.get(
            reverse('app_data:api_index'),
            headers={"X-Cavaliba-Key": "key2 secret2"},
        )
        self.assertEqual(response.status_code, 200)

    # /home/api/version/

    def test_api_home_version(self):

        response = self.client.get(
            reverse('app_home:api_version'),
            headers={"X-Cavaliba-Key": "key1 secret1"},
        )
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, "version")
        # rint(response.content)

# /home/api/info/
