/*
Copyright © 2025 cavaliba.com
*/
package cmd

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// infoCmd represents the info command
var infoCmd = &cobra.Command{
	Use:   "info",
	Short: "display information about a Cavaliba instance",
	Long:  `Call cavaliba and display general information about the instance`,
	Run: func(cmd *cobra.Command, args []string) {

		target := APITarget{
			url:            viper.GetString("url") + "info/",
			ssl_skipverify: viper.GetBool("ssl_skipverify"),
		}

		result, err := CallAPI(target)
		if err != nil {
			fmt.Println(err)
			os.Exit(0)
		}

		PrintVerbose(target, result)
		fmt.Println(result.body)

	},
}

func init() {
	rootCmd.AddCommand(infoCmd)
}
