/*
Copyright © 2025 NAME HERE <EMAIL ADDRESS>
*/
package cmd

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// versionCmd represents the version command
var versionCmd = &cobra.Command{
	Use:   "version",
	Short: "displays remote cavaliba version",
	Long:  `Call cavaliba and displays instance version`,
	Run: func(cmd *cobra.Command, args []string) {

		target := APITarget{
			url:            viper.GetString("url") + "version/",
			ssl_skipverify: viper.GetBool("ssl_skipverify"),
		}

		result, err := CallAPI(target)
		if err != nil {
			fmt.Println(err)
			os.Exit(0)
		}

		PrintVerbose(target, result)
		fmt.Println(result.body)

	},
}

func init() {
	rootCmd.AddCommand(versionCmd)
}
