/*
Copyright © 2025 cavaliba.com
*/
package cmd

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// schemaCmd represents the schema command
var schemaCmd = &cobra.Command{
	Use:   "schema",
	Short: "display schema information from Cavaliba instance",
	Long:  `Call cavaliba and display schema information`,
	Run: func(cmd *cobra.Command, args []string) {

		target := APITarget{
			url:            viper.GetString("url") + "schema/",
			ssl_skipverify: viper.GetBool("ssl_skipverify"),
		}

		result, err := CallAPI(target)
		if err != nil {
			fmt.Println(err)
			os.Exit(0)
		}

		PrintVerbose(target, result)
		fmt.Println(result.body)

	},
}

func init() {
	rootCmd.AddCommand(schemaCmd)
}
