---
title: float
description: FieldType Float
weight: 212
---

Represents a floating-point number with decimal precision.

## dataformat: float

```yaml
  MYFIELD:
      dataformat: float
      dataformat_ext: [gt_#|gte_#|lt_#|lte_#]
      default: 3.14
```

## dataformat_ext

Optional **dataformat_ext** can be a combination of:

- **gt_123.45**: Greater than 123.45
- **gte_100.0**: Greater than or equal to 100.0
- **lt_200.5**: Less than 200.5
- **lte_150.0**: Less than or equal to 150.0

Multiple constraints can be combined (space-separated).

## Multivalue

Multi-value is supported.

```yaml
## SCHEMA
MYPRICES:
      dataformat: float
      cardinal_max: 0

## INSTANCE multi-valued
  MYPRICES: [9.99, 19.99, 29.99]
  # or as space-separated string
  MYPRICES: '9.99 19.99 29.99'
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: product
  price:
    dataformat: float
    displayname: Price
    description: Product price in currency units
```

### Instance Example

```yaml
- classname: product
  keyname: item1
  price: 29.99
```

## Notes

- Float values are stored with full precision in the database
- Use constraints to enforce valid ranges (e.g., percentages, ratings)
- Decimal separator is always `.` regardless of locale
