# (c) cavaliba.com - tests / helper test

from django.test import override_settings
from django.test import TestCase
from django.core.cache import cache as cache_django

from tests import helper
import app_home.cache as cache

from app_data.models import DataInstance


class HelperTest(TestCase):

    fixtures = ["init"]

    def setUp(self):
        helper.add_admin_user(login="unittest")
        cache.clear()
        cache_django.clear()

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_add_test_sites(self):
        # Create 5 test sites
        helper.add_test_sites(count=5)

        # Verify they were created
        sites = DataInstance.objects.filter(classname='site', keyname__startswith='site')
        self.assertEqual(sites.count(), 5)

        # Verify naming
        site01 = DataInstance.objects.filter(classname='site', keyname='site01').first()
        self.assertIsNotNone(site01)
        self.assertEqual(site01.displayname, 'Site 01')

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_add_test_sites_custom_count(self):
        # Create 3 test sites
        helper.add_test_sites(count=3)

        # Verify only 3 were created
        sites = DataInstance.objects.filter(classname='site', keyname__startswith='site')
        self.assertEqual(sites.count(), 3)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_add_test_apps(self):
        # Create 5 test apps
        helper.add_test_apps(count=5)

        # Verify they were created
        apps = DataInstance.objects.filter(classname='app', keyname__startswith='app')
        self.assertEqual(apps.count(), 5)

        # Verify naming
        app01 = DataInstance.objects.filter(classname='app', keyname='app01').first()
        self.assertIsNotNone(app01)
        self.assertEqual(app01.displayname, 'App 01')

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_add_test_apps_custom_count(self):
        # Create 3 test apps
        helper.add_test_apps(count=3)

        # Verify only 3 were created
        apps = DataInstance.objects.filter(classname='app', keyname__startswith='app')
        self.assertEqual(apps.count(), 3)
