---
title: datetime
description: FieldType DateTime
weight: 215
---

Represents a date and time value with timestamp precision.

## dataformat: datetime

```yaml
  MYFIELD:
      dataformat: datetime
      default: "2025-01-01T00:00:00"
```

## dataformat_ext

**Not used** - DateTime fields have no extended options. ISO 8601 format (YYYY-MM-DDTHH:MM:SS) is always used.

## Format

DateTime values are stored and displayed in ISO 8601 format: **YYYY-MM-DDTHH:MM:SS**

Examples:
- 2025-01-15T14:30:00
- 2024-12-31T23:59:59
- 2025-06-20T09:15:30

## Timezone

DateTime values are typically stored in UTC or server timezone. The timezone information is not stored in the field itself.

## Multivalue

Multi-value is supported for storing multiple timestamps.

```yaml
## SCHEMA
MYEVENTS:
      dataformat: datetime
      cardinal_max: 0

## INSTANCE multi-valued
  MYEVENTS: [2025-01-15T14:00:00, 2025-01-16T10:30:00]
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: document
  created_at:
    dataformat: datetime
    displayname: Created At
    description: Document creation timestamp
```

### Instance Example

```yaml
- classname: document
  keyname: doc1
  created_at: "2025-01-10T09:00:00"
```

## Notes

- DateTime picker widget provided in edit forms
- ISO 8601 format (YYYY-MM-DDTHH:MM:SS) is standard
- Suitable for audit trails, event logs, and scheduling
- Use `date` field type if time component is not needed
- Use `time` field type if date component is not needed
