# (c) cavaliba.com - test / status

from django.test import override_settings
from django.test import TestCase
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django

from tests import helper


from app_home.configuration import get_configuration
import app_home.cache as cache

from app_user.models import SireneUser
from app_user.role import role_get_by_name


class AppStatusTest(TestCase):

    fixtures = ["init"]

    def setUp(self):
        cache.clear()
        cache_django.clear()

        helper.add_admin_user(login="unittest")

    def tearDown(self):
        cache_django.clear()


    # @override_settings(CAVALIBA_DEBUG_AAA="yes")
    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_appstatus_list(self):
        response = self.client.get(reverse('app_status:list'))
        self.assertEqual(response.status_code, 200)
