/*
Copyright © 2025 cavaliba.com
*/
package cmd

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"
	"github.com/spf13/viper"
)

// userCmd represents the user command
var userCmd = &cobra.Command{
	Use:     "user",
	Short:   "displays user information",
	Long:    `Call cavaliba users/ API endpoint and displays user information. Use --id flag to specify a user ID or --key flag to specify a key.`,
	Aliases: []string{"users"},
	Run: func(cmd *cobra.Command, args []string) {

		endpoint := "users/"

		// Check if --id flag was provided (priority over --key)
		if cmd.Flags().Changed("id") {
			endpoint = fmt.Sprintf("users/%d/", id)
		} else if cmd.Flags().Changed("key") {
			endpoint = fmt.Sprintf("users/%s/", key)
		}

		target := APITarget{
			url:            viper.GetString("url") + endpoint,
			ssl_skipverify: viper.GetBool("ssl_skipverify"),
		}

		err := AppendGlobalOptions(&target)
		if err != nil {
			fmt.Println(err)
			os.Exit(1)
		}

		PrintVerboseTarget(target)

		result, err := CallAPI(target)
		if err != nil {
			fmt.Println(err)
			os.Exit(0)
		}

		PrintVerboseResult(result)
		fmt.Println(result.body)

	},
}

func init() {
	rootCmd.AddCommand(userCmd)
}
