# (c) cavaliba.com - test_data_revision.py


from django.test import TestCase

import app_home.cache as cache

from app_data.models import DataRevision
from app_data.revision import revision_add_raw
from app_data.revision import revision_get
from app_data.revision import revision_purge


class TestDataRevision(TestCase):

    def setUp(self):
        cache.clear()

    def test_revision_add_raw(self):
        revision_add_raw(
            aaa=None,
            classname="classtest",
            keyname="keytest",
            action="test")
        count = DataRevision.objects.count()
        self.assertEqual(count, 1)
        rev = DataRevision.objects.first()
        self.assertEqual(rev.classname, "classtest")
        self.assertEqual(rev.keyname, "keytest")
        self.assertEqual(rev.displayname, None)
        self.assertEqual(rev.action, "test")

    def test_revision_add_raw_with_displayname(self):
        revision_add_raw(
            aaa=None,
            classname="classtest",
            keyname="keytest",
            action="test")
        rev = DataRevision.objects.first()
        rev.displayname = "Test Display Name"
        rev.save()
        rev_updated = DataRevision.objects.first()
        self.assertEqual(rev_updated.displayname, "Test Display Name")

    def test_revision_get(self):
        revision_add_raw(
            aaa=None,
            classname="classtest",
            keyname="keytest",
            action="test")
        revqs = revision_get(classname="classtest", keyname="keytest")
        self.assertEqual(len(revqs), 1)

    def test_revision_purge(self):
        count = revision_purge()
        self.assertEqual(count, 0)

    # TODO
    # revision_add
    # client view edit instance/user/group/role => see Revision entry
    # client view detail => Revision dropdwon content
