---
title: APP - Notification (Sirene)
description: Sirene Notification App
weight: 100
---


**Sirene** - a notification App to send SMS/Mail/Web notifications to uses, employees, customers.



## Sirene Concepts


When an important event occurs, like a scheduled Maintenance, an IT outage, or a security breach, you may need to communicate with your users to inform, warn, provide recommandations, activate emergency response plan, etc.

Sirene is a tool included in Cavaliba to provide **fast** and **high-quality** notifications.

Key points:

* Sirene uses the **integrated data model** provided by Cavaliba for a description of users, sites, groups, services, and their relationships
* Sirene provides **Templates** for predefined / frequent messages. They can always be adjusted at notification time.
* Sirene provides several notifications **channels** : Web (several kind), Email, SMS
* Sirene **computes** automatically target users for a specific message (see Notification Targets)
* Sirene let you send messages **updates** (additional notifications)
* Sirene removes old notification and send them to an **archive** for audit trail and statistics for example.

Sirene is not intended to be an "automated notification system", connected to some monitoring solution. It is rather designed to be used manually by a **human operator** in charge of decisions and notifications. You can still decide to use the Sirene API for automatic notifications though.



## Sirene Data Model


Sirene uses the following model :  **Sites**, **Groups of Sites**, **Applications and Services**, **Users**, **Groups of users**, **Customers**.

- **Sites** describe geographical entities like offices, head quarters, agency, factories, ...
- **Groups of Sites** are sets of site, based on any criteria  like region,  geography, activity, business-unit, etc.
- **Applications and Services** are assets which may be the subject of a notification : IT application, business process, etc.
- **Users** and **Groups of Users** are any sets of regular Cavaliba Users
- **Customers** can be used in a Service Provider model, where a company has many customers and would like to notfy a selected subset of these customers.


The relationship between applications and sites is a key element to understand  : Sites object contains a list of **subscribed** applications for which they want to be notified when a notification targets an application.  Subscription means **this site wants to be notified for this applicaiton**.


## Notification Targets and Decision

A Sirene Operator can send notifications to any **combination** of targets : Sites, Groups of Sites, Applications, Users, Groups of Users, Customers.

Sirene computes automatically the list of users to be notified with the following rules:

* a notification to a **site** will reach all users registered with the Site (under the "site notification" attribute)
* a notification to a **group of site** will reach all users of each Site in the Group of Sites.
* a notification to a **group of users** will obviously reach each user in the group
* a notification to an **application/service** will reach :

    - all users registered directly with the application (like the person in charge of the service, mainteners, operators)
    - all users of sites which subscribed to the application/service 

Each users is notified once per message notification, that is he receives only one Email / SMS notification even if he belongs to several notifications targets.


## Channels

Cavaliba Sirene can send notifications through various communication channels :

- **Public Web Page** available to all person, authenticated or not, who can reach the Cavaliba Web system
- **Trusted Web Page**  available to all person with a trusted origin (trusted source IP address) 
- **Private Web Page** available to all users authenticated successfully in Cavaliba. 
- **Restricted Web Page** available to some specific users, after authentication in Cavaliba
- **Email** to specific users or groups of users
- **SMS** to specific users or groups of users

At a later point, Cavaliba may provide Slack or Teams Channel notifications



## Templates - Prepare your messages

It's not a good idea to write a message from a blank formular in the middle of the night during an urgent situation.

That's what templates are for. You can prepare as many messages models as you wan't, including target groups, hints, public web page content, private web page content and more.

During the notification process a Sirene Operators will :

* select an appropriate template from a list
* review the message recommandation and the intended use case if any
* review and adapt the message if needed : content, channels and targets (sites, groups)
* ... send with a clic

Of course, an operator can always craft a new message from a blank form during an event, but templates are really there to improve the quality and speed of notifications.

## Message Removal and Archives

When the triggering condition is over, or after a configurable period of time, Sirene will remove notifications displayed in the various Web Page and move the message to an Archive Repository.

Sirene Users and Operators can consult this archive to view past events and the communication around them.


## Message Updates

An operator can send updates to a an active notification before it is removed and sent to archive.

It's a good idea to send an Update before removing (archiving) a message to inform users about the end of the event.

For example, you can keep your users updated with the progress of a long / important maintenance, and expected time of reopening of the service.


## User preferences 

 Users can configure individual preferences regarding the notifications channels :
- activate / desactivate Mail or SMS notifications
- enable 24/7 notifications (outside of Business Hours)
- configure a secondary Email address or Mobile Phone number.


## Use case examples

- **information** : a new system / a new software version will be available
- **outage** : an incident or IT outage, you wan'to notify users, and IT mainteners.
- **maintenance** : some system will go to maintenance and won't be available for a period of time
- **security alert** : warn some users that an extra caution is required in case of security event
- **crisis management** : open a situation room, call for crisis managers

