---
title: User and Groups
description: Create, import, export, and manage users in Cavaliba - UI, YAML, CSV, and pipelines
weight: 20
draft: false
---

User management is a core component of Cavaliba's IAM (Identity & Access Management) system. In this section, we'll explore multiple ways to create and manage users: through the web interface and bulk imports via YAML files.

We'll then move on to Groups, which are the proper way to organize users by any characteristic and to provide a more manageable object to scale Cavaliba to tens of thousands of users or more.


## Create a User from the UI

Let's start by creating a user directly from the Web UI.

### User List

Click on Users in the sidebar. When you first navigate to the Users section, it's mostly empty, except for the built-in admin account or any previously created user.


![Users Empty List](users_empty.png)

### Edit the user form

Click the `New` button to open the user creation form and fill it in:

![New User Form](new_user.png)

The form includes fields for:
- **Login** - Unique username for authentication; mandatory field.
- **First Name** - User's first name
- **Last Name** - User's last name
- **Display Name** - Full name or display identifier
- **Email** - Primary email address
- **Mobile** - Phone number
- **Description** - Additional notes or purpose
- **Enabled** - Toggle to activate/deactivate the user
- **Notification Preferences** - Email/SMS notification settings

Fill in the required fields and click "Save".

### User details

After saving, you'll see a confirmation message and the user appears in the Detail window:

![New User Created](new_user_done.png)

The user list now shows your newly created user with details like login, display name, and email.

![User List with Created User](new_user_list.png)


## Bulk Import Users

For any practical deployment, you will import multiple users at once (and periodically) using CSV, JSON, or YAML files, or API REST calls. Cavaliba provides demo user data that you can load directly.

We've already seen in PART-1 how to import from the UI Import tool.

This time we'll use the CLI command to import a set of demo users already included in the Cavaliba application :

```bash
cavaliba load builtin/demo/010_user.yaml
```

![Bulk Import Users Command](user_bulk.png)

This command loads the users defined in the demo YAML file. 






## Note on the User YAML format

Users imported from YAML follow this schema:

```yaml
- classname: _user
  login: adela81
  firstname: Marijn
  lastname: ...
  (...)
```
The `login` field is the primary key. An email format is accepted. Mandatory fields are `classname: _user` and `login` (`keyname` is supported to match the general Schema). Similar JSON structures are supported.

The underscore before the user schema, indicates a builtin Schema. Don't use underscore for your own Assets schema names.

We can inspect (and edit) the YAML code of any object from the UI.

In the search filter, enter a username and click on the search button. Choose a user from the filtered list of users and click on its name. You should see the detailed page for this user.

Open the Action dropdown menu and select `Code`.

![Code Edit](user_edit_code.png)

You're now in the `Import` tool we've seen in PART-1, filled with the users' YAML description. You can modify and import to replace the previous values. 

![User YAML](user_yaml.png)


## Working with CSV file format

The CSV file format is also available for import in Cavaliba. But its use is covered in a later PART of this tutorial as it requires `Pipelines` object to pre-process the data from CSV file.


## Export Users

Cavaliba allows you to export users to similar format for backup, sharing, or integration with other systems.

Use the export functionality in the User UI (dropdown Export) or CLI to download your user data in various formats.

![Export Users from UI](user_export_from_ui.png)

From the command line (CLI):

```bash
# Export to JSON
cavaliba schema --export _user

# Export to YAML
cavaliba schema --export _user --format yaml
```

## Delete a User

You can delete users from the Web UI. Find the user and use the `Delete` button from the `Action` dropdown.

![User Delete](user_delete.png)

Alternatively, you can delete a user with JSON or YAML code (CLI or UI Import tool):

```yaml
- classname: _user
  login: adela81
  _action: delete
```

Other action values are available:
- `init` - Only creates the object if it doesn't exist
- `update` - Only updates the object; does nothing if it doesn't exist; only provided values will be updated, other fields are left untouched

Try to retrieve a Delete operation in the Logs


## Disabling a User

Every object—User, Group, and all objects from user-defined schemas—can be deactivated. This makes them unavailable in the UI or data models without the risk associated with permanent deletion.

From a Web UI form, edit a User or any object and unset the `is_enabled` checkbox.

![User Disable](user_disable.png)

From JSON/YAML, use the `is_enabled` attribute:

```yaml
- classname: _user
  login: adela81
  is_enabled: no
```

Cavaliba supports the following values for `is_enabled`: yes, no, Yes, True, false, 0, 1, on, OFF, etc.


## Managing Large User Datasets

Once you have imported users via any method (UI, YAML, JSON), you can:
- Edit individual user records
- Bulk update manually or automatically
- Export for backup or integration
- Organize users into groups (see the Groups section of this tutorial)
- Assign roles and permissions (see IAM & Permissions)

You'll see later how to configure periodical import/export task, or use the REST API to remotely import/export Users and other data objects.


## Groups

If you have more than a few users in your organization, managing them one by one will quickly become tedious. By managing, we mean assigning permissions, Assets schemas, etc.

Groups let you organize users with similar characteristics and manage them as a single entity. 


### From the UI

Let's create a group from the UI.

Click on the Groups link in the left sidebar. Then click on `New` to open the form to add a new group.

Fill the form with:
- a keyname (short ID for machines, no special chars) : g_accountant
- a display name (for humans) : Group Accountants
- an optional description: Group for Accountants
- skip the autogroup feature for now
- skip the subgroups for now
- select some users to populate the group , from the previous PART of the tutorial.

Click on Save when done. 

You'll get the following result:

![Group create](group_create.png)

You've created a group for people from the Accountant Department.

It is a good idea to adopt a strong naming convention around groups and various objects in Cavaliba. Using a `g_` prefix for groups keyname is good.


### From JSON/YAML Code

When dealing with many groups and a large number of users, moving away from the mouse and using configuration files is helpful.

Go to the UI Import tool from the sidebar and paste the following snippet:


```yaml
- classname: _group
  keyname: g_staff
  displayname: Group Staff
  description: Group for Staff members
  users: 
  - adina61
  - bethany89
```

Check and Save. You've created a group. You can also create a group with the load command from the CLI as seen before.




### Nested Groups

A group can contain subgroups. This makes groups well-suited to describe hierarchical organization structures.

Use the `subgroups` attribute either from the UI web form or the Import tool.


### Demo Groups

We've included two sets of demo data that you can import from the CLI:

```
cavaliba load builtin/demo/012_group.yaml
cavaliba load builtin/demo/014_group_mgmt.yaml
```



![Group list](group_list.png)


### Add-on

Take some time to inspect groups in the UI. Explore the group's Action options to edit or delete, view YAML code, and check operations in Logs or Data Revision as seen in PART-1.

The `copy email` feature copies all emails from members of the group to the clipboard for easy usage in email clients.



## What's Next?

You've learned how to manage users and groups from the UI, web forms, or bulk files. You can now proceed to the next part, which covers Asset schema creation.
