---
title: Enumerate
description: Reference
weight: 203
---


Enumerate are lists of predefined values which can be used as a FieldType when designing Data Model and defining Schema. Enumerate values have various additional options : display widget, description or intended use, etc.

In the UI, when editing an asset, users will be presented with a list of available values only. When displaying an asset, nice widgets can be presented to users.


Enumerate usecase examples:

- **status** : OK, KO, N/A
- **maturity_level** : Good, Medium, Average, Bad, Terrible, NotAvailable, Unkown, ToBeChecked,  ...
- **grade** : A,B,C,D,E
- **fruits**  : apple, pear, mango, ...
- **publish_status** : draft, published, retracted
- **color** :  red, blue, yellow


## Create an enumerate

Enumerates are implemented with a builtin Schema `_enumerate` and can thus be managed from the Web UI, REST API, console CLI, import/export, etc.

```yaml
- classname: _enumerate
  keyname: country
  displayname: Country List
  description: "List (enumerate) of valid countries"
  content: |
    - value: "Belgium"
    - value: "Canada"
    - value: "Australia"
    - value: "Italy"
    - value: "Other"
```

## Use an enumerate

A schema can declare fields of `dataformat: enumerate`.  The `dataformat_ext` contains the name of the enumerate to be used.

```yaml
- classname: _schema
  keyname: vacation
  displayname: "Our Vacations"
  description: "Schema for our Vacations"

  (...)

  country:
     dataformat: enumerate
     dataformat_ext: country      // name of the enumerate to use
```


Every object will have an (optional) field named `country` with a value constrained by the available enumerate values (Belgium, Italy, ...)



## More attributes per enumerate value

A selected enumerate value can inject additional values to the object.

Consider this new `country` enumerate:

```yaml
- classname: _enumerate
  keyname: country2
  displayname: Country List
  description: "List (enumerate) of valid countries"
  content: |
    - value: "Belgium"
      iso: BE                 // new attribute in addition to value
    - value: "Canada"
      iso: CA
    - value: "Australia"
      iso: AU
    - value: "Italy"
      iso: IT
    - value: "Other"
      iso: ??

```

Now, if your vacation Schema uses the country2 enumerate, each vacation object will have:

* a `country` attribute with the enumerate value selected (Belgim)
* a `country__iso` attribute with the associated ISO Country code.

The rule is that additional enumerate info besides value, get automatically injected as new fields with a name consisting of the original field name (country), plus a double underscore (`__`), plus the additional attribute name (iso)

## Additional attributes have type

Consider the following enumerate (from the test suite):

```yaml
- classname: _enumerate
  keyname: enumerate_test
  displayname: "Enumerate Test ABCDE"
  description: "Enumerate Test ABCDE"
  content: |
    - value: "A"
      long: "A - OK"
      widget: "green_circle"
      num: 1
      description: "Use if perfect"
      enumstring: string AAA
      enumint: int 111
      enumfloat: float 111.1
      enumboolean: boolean no

    (...)


    - value: "complex"
      widget: 'html <span class="badge bg-dark">Widget</span> &nbsp;'
      enumstring: string test_enum_string
      enumint: int 123
      enumfloat: float 99.95
      enumboolean: boolean no
```          


Injected fields will be cast to the provided field type.

For example, numerical values, can be used later in the procession of data (dataviews), to create numerical aggregate (min, max, avg, ...)



## widget special attribute

A special widget attribute is available to provide enhanced visual effects, such as HTML pills, badge, etc.

Some predefined widget values automatically mapped to coloured bullets:

```
    "red_circle":    "&#x1f534;",
    "orange_circle": "&#x1F7E0;",
    "yellow_circle": "&#x1F7E1;",
    "green_circle":  "&#x1F7E2;",
    "purple_circle": "&#x1F7E3;",
    "brown_circle":  "&#x1F7E4;",
    "blue_circle":   "&#x1F535;",
    "white_circle":  "&#x25EF;",
    "black_circle":  "&#x2B24;",      # large
    "default" : ""
    
```


![List](enumerate_widget.png)




## Builtin enumerate

Cavaliba comes with the following builtin enumerates:

* sirene_category
* sirene_severity
* status_monitor_type
* ipam_vlan_family

You can inspect them in the Web UI.


