---
title: schema
description: FieldType Schema
weight: 233
---

References one or more other data schemas (DataClass). Creates relationships between different data object types.

## dataformat: schema

```yaml
  MYFIELD:
      dataformat: schema
      dataformat_ext: classname_to_reference
```

## dataformat_ext

**Required**: Specifies the schema (DataClass) to reference.

- Value: The classname (schema name) to link to
- Example: `dataformat_ext: server` references the "server" schema

## Multivalue

Multi-value is supported for many-to-many relationships.

```yaml
## SCHEMA
MYSCHEMAS:
      dataformat: schema
      dataformat_ext: target_schema
      cardinal_max: 0

## INSTANCE multi-valued
  MYSCHEMAS: [obj1, obj2, obj3]
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: service
  deployed_on_server:
    dataformat: schema
    dataformat_ext: server
    displayname: Deployed On Server
    description: Server where service runs
```

### Instance Example

```yaml
- classname: service
  keyname: web_app
  deployed_on_server: server_prod_01
```

## Related Objects (Reverse Reference)

When viewing a schema instance in detail:
- Related objects referencing it are shown
- Shows all instances that point to the current object
- Bidirectional relationship visibility

## Notes

- Creates references between different object types (schemas)
- Fundamental for building data models with relationships
- Multi-value creates many-to-many relationships
- Single-value creates many-to-one relationships
- Used extensively in data modeling and organization
- Related objects automatically indexed and cached
- Forms basis for complex data structures and workflows
