---
title: Backup and restore
description: Backups and Restore
weight: 720
---


## System `.env` file

You must backup and protect the docker .env file in the cavaliba app directory.

    $ cd appdir/
    $ cp .env /my/backup/dir/

It contains sensitive informations needed at startup time. It is created / modified during system setup and reconfig/

Most needed data are encryption keys, and various credentials : DB, admin account, OIDC client secrets, etc.

Restoration is a simple as copying back the file to the restored application folder.


## Application configuration

Most configuration items are managed from the application itself, and are stored in the database.

You must backup this configuration:

    $ cd appdir/                                              # or whatever your setup root dir is
    $ cavaliba conf                                           # show current configuration
    $ cavaliba conf --yaml > files/export/conf_backup.yaml    # load and replace in-DB configuration


Remember to setup `cavaliba` as an alias to management commands as explained in the command-line (CLI) doc page.

To restore the configuration on a new  deployement :

    $ cd appdir
    $ cavaliba conf 
    $ cavaliba conf --conf_file /files/export/conf_backup.json

Notice the `/` before files/ to ensure access from inside the containers.


##  Full database backup

Cavaliba provides `script/db_backup.sh ` to backup the full MySQL/MariaDB automatically.

Setup:

    1. create your backup dir
    2. install standard zstd compression tool if missing
    3. edit the script and set your choosen DB password (.env), BACKUPDIR
    4. launch manually ./script/db_backup and check produced backup file in your Backupdir
    3. add to crontab with provided example in the script

       25 */6 * * * /opt/cavaliba/script/db_backup.sh > /tmp/backup_db.log 2>&1

It creates a periodically rolling backup for 7 days.

Restore:

You can restore as a standard MariaDB / MySQL dump 

    1. stop the application
    2. drop / create cavaliba_db in your mysql server
    3. zstdcat mybackup.zstd | mysql cavaliba_db


## Logicial Data backup

Cavaliba provides a simple data_export script:

```bash
# (c) cavaliba.com - DATA Export backup script
#
# crontab example
# 45 */6 * * * /opt/cavaliba/script/data_backup.sh > /tmp/backup_data.log 2>&1


BACKUPDIR="/opt/cavaliba/backup"
USER="root"
PASSWORD="xxxxxxxxxxxxxxxxxxx"

cd $BACKUPDIR

DAY=$(date "+%u")
HOUR=$(date "+%H")


DATE=$(date +%Y%m%d_%H:%M:%S)
FILE="$BACKUPDIR/${DAY}_${HOUR}_schema.zst"
echo "$DATE start dumping SCHEMA to $FILE"
docker exec cavaliba_app python manage.py dumpdata --format json --indent 2 app_data.dataschema --natural-primary --natural-foreign | zstd >$FILE

DATE=$(date +%Y%m%d_%H:%M:%S)
FILE="$BACKUPDIR/${DAY}_${HOUR}_classname.zst"
echo "$DATE start dumping CLASS to $FILE"
docker exec cavaliba_app python manage.py dumpdata --format json --indent 2 app_data.dataclass --natural-primary --natural-foreign | zstd >$FILE

DATE=$(date +%Y%m%d_%H:%M:%S)
FILE="$BACKUPDIR/${DAY}_${HOUR}_instance.zst"
echo "$DATE start dumping INSTANCE to $FILE"
docker exec cavaliba_app python manage.py dumpdata --format json --indent 2 app_data.datainstance --natural-primary --natural-foreign | zstd >$FILE

DATE=$(date +%Y%m%d_%H:%M:%S)
FILE="$BACKUPDIR/${DAY}_${HOUR}_conf.zst"
echo "$DATE start dumping CONF to $FILE"
docker exec cavaliba_app python manage.py dumpdata --format json --indent 2 app_home.cavalibaconfiguration --natural-primary --natural-foreign | zstd >$FILE


DATE=$(date +%Y%m%d_%H:%M:%S)
FILE="$BACKUPDIR/${DAY}_${HOUR}_iam.zst"
echo "$DATE start dumping IAM (USER GROUPS PERM ROLES) to $FILE"
docker exec cavaliba_app python manage.py dumpdata --format json --indent 2 app_user --natural-primary --natural-foreign | zstd >$FILE

```

## CLI data export 

You can export specific object to any file:

    $ cavaliba schema --schema mybookstore --json > /my/backup/dir/schema_mybookstore.json

And reload with

    $ cavaliba load schema_mybookstore.json


## Cavaliba Software distribution

You should also keep the downloaded software distribution for later reinstall :

    $ wget https://cavaliba.com/download/cavaliba/latest.tar.gz
    $ cp latest.tar.gz /my/backup/dir
