# (c) cavaliba.com  - data/api - info.py

from django.views.decorators.csrf import csrf_exempt, csrf_protect
from django.utils.translation import gettext as _

from app_home.log import log, DEBUG, INFO, WARNING, ERROR, CRITICAL

from app_user.aaa_api import start_api

from app_data.models import DataClass, DataInstance, DataSchema, DataEAV, DataFile
from app_user.models import SireneUser, SireneGroup, SirenePermission, SireneVisitor
from app_home.models import CavalibaConfiguration, CavalibaAPIStat, CavalibaLog, DashboardApp
from app_sirene.models import SMSJournal
from app_status.models import StatusRaw, StatusSampleDay, StatusSampleHour


from .helper import send_denied
from .helper import send_response





#  ----------------------------------------------------------------------------
# /api/info/
#  ----------------------------------------------------------------------------
@csrf_exempt
def info(request):

    aaa_api = start_api(request, permission="p_info")
    if not aaa_api["is_allowed"]:
        return send_denied()


    reply = {}
    reply ["schema_count"] = DataClass.objects.count()
    reply ["field_count"] = DataSchema.objects.count()
    reply ["instance_count"] = DataInstance.objects.count()
    reply ["instance_eav"] = DataEAV.objects.count()
    reply ["instance_file"] = DataFile.objects.count()

    reply ["user_count"] = SireneUser.objects.count()
    reply ["group_count"] = SireneGroup.objects.filter(is_role=False).count()
    reply ["role_count"] = SireneGroup.objects.filter(is_role=True).count()
    reply ["permission_count"] = SirenePermission.objects.count()
    reply ["visitor_count"] = SireneVisitor.objects.count()

    reply ["configuration_count"] = CavalibaConfiguration.objects.count()
    reply ["log_count"] = CavalibaLog.objects.count()
    reply ["apistat_count"] = CavalibaAPIStat.objects.count()
    reply ["dashboard_count"] = DashboardApp.objects.count()

    reply ["smsjournal_count"] = SMSJournal.objects.count()

    reply ["status_raw_count"] = StatusRaw.objects.count()
    reply ["status_sample_hour_count"] = StatusSampleHour.objects.count()
    reply ["status_sample_day_count"] = StatusSampleDay.objects.count()


    log(DEBUG, aaa=aaa_api, app="api", view="info", action="GET", status="OK", data="")

        
    # NEXT: last housekeeping 

    return send_response(request, reply, 200)


